% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraint_penalty.R
\name{constraint_penalty}
\alias{constraint_penalty}
\title{"Penalty" constraint handling method for MOEA/D}
\usage{
constraint_penalty(B, bigZ, bigV, beta, ...)
}
\arguments{
\item{B}{Matrix of neighborhoods (generated by \code{\link[=define_neighborhood]{define_neighborhood()}}\code{$B})}

\item{bigZ}{Matrix of scalarized objective values for each neighborhood and
the incumbent solution (generated by \code{\link[=scalarize_values]{scalarize_values()}})}

\item{bigV}{Matrix of violation values for each neighborhood and the
incumbent solution (generated in \code{\link[=order_neighborhood]{order_neighborhood()}})}

\item{beta}{Penalization constant (non-negative value)}

\item{...}{other parameters (unused, included for compatibility with
generic call)}
}
\value{
\code{[ N x (T+1) ]} matrix of preference indices. Each row \code{i} contains
a permutation of \code{{1, 2, ..., (T+1)}}, where \code{1,...,T} correspond
to the solutions contained in the neighborhood of the i-th subproblem,
\code{B[i, ]}, and \code{T+1} corresponds to the incumbent solution for that
subproblem. The order of the permutation is defined by the increasing values
of \code{f(xk) + beta * v(xk)}, where \code{f(xk)} is the aggregation function value of
the k-th solution being compared, and v(xk) is its total constraint violation
(calculated in \code{\link[=evaluate_population]{evaluate_population()}}\code{$V$v}).
}
\description{
Uses the Penalty Function constraint handling method to generate a
preference index for the MOEADr framework.
}
\details{
This function calculates the preference index of a set of neighborhoods
based on the "penalty" constraint handling method. Please
see \code{\link[=order_neighborhood]{order_neighborhood()}} for more information on the preference index
matrix.
}
