% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_dvls.R
\name{ls_dvls}
\alias{ls_dvls}
\title{Differential vector-based local search}
\usage{
ls_dvls(Xt, Yt, Vt, B, W, which.x, trunc.x, problem, scaling, aggfun,
  constraint, ...)
}
\arguments{
\item{Xt}{Matrix of incumbent solutions}

\item{Yt}{Matrix of objective function values for Xt}

\item{Vt}{List object containing information about the constraint violations
of the \emph{incumbent solutions}, generated by \code{\link[=evaluate_population]{evaluate_population()}}}

\item{B}{Neighborhood matrix, generated by \code{\link[=define_neighborhood]{define_neighborhood()}}.}

\item{W}{matrix of weights (generated by \code{\link[=generate_weights]{generate_weights()}}).}

\item{which.x}{logical vector indicating which subproblems should undergo
local search}

\item{trunc.x}{logical flag indicating whether candidate solutions generated
by local search should be truncated to the variable limits of the problem.}

\item{problem}{list of named problem parameters. See Section
\code{Problem Description} of the \code{\link[=moead]{moead()}} documentation for details.}

\item{scaling}{list containing the scaling parameters (see \code{\link[=moead]{moead()}} for
details).}

\item{aggfun}{List containing the aggregation function parameters. See
Section \code{Scalar Aggregation Functions} of the \code{\link[=moead]{moead()}} documentation for
details.}

\item{constraint}{list containing the parameters defining the constraint
handling method. See Section \code{Constraint Handling} of the \code{\link[=moead]{moead()}}
documentation for details.}

\item{...}{other parameters (included for compatibility with generic call)}
}
\value{
List object with fields \code{X} (matrix containing the modified points,
with points that did not undergo local search indicated as NA) and \code{nfe}
(integer value informing how many additional function evaluations were
performed).
}
\description{
Differential vector-based local search (DVLS) implementation for the MOEA/D
}
\details{
This routine implements the differential vector-based local search for
the MOEADr package. Check the references for details.

This routine is intended to be used internally by \code{\link[=variation_localsearch]{variation_localsearch()}},
and should not be called directly by the user.
}
\section{References}{

B. Chen, W. Zeng, Y. Lin, D. Zhang,
"A new local search-based multiobjective optimization algorithm",
IEEE Trans. Evolutionary Computation 19(1):50-73, 2015.
}

