% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportCoverage.R
\name{exportDifferentials}
\alias{exportDifferentials}
\title{\code{exportDifferentials}}
\usage{
exportDifferentials(
  SampleTileObject,
  DifferentialsGRList,
  outDir,
  verbose = FALSE
)
}
\arguments{
\item{SampleTileObject}{The SummarizedExperiment object output from
\code{getSampleTileMatrix}}

\item{DifferentialsGRList}{GRangesList output from
\code{getDifferentialAccessibleTiles}}

\item{outDir}{Desired output directory where bigBed files will be saved}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}
}
\value{
outList A List of output filepaths
}
\description{
\code{exportDifferentials} exports the differential peaks
 output GRangesList output from \code{getDifferentialAccessibleTiles} to
 bigBed format for visualization in genome browsers.
}
\examples{
\dontrun{
MOCHA::exportDifferentials(
  SampleTileObject = SampleTileMatrices,
  DifferentialsGRList,
  outDir = tempdir(),
  verbose = TRUE
)
}

}
