% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{MLeffort}
\alias{MLeffort}
\title{Mean length with effort mortality estimator}
\usage{
MLeffort(MLZ_data, start, n_age, estimate.M = TRUE, log.par = FALSE,
  eff_init = 0, n_season = 1L, obs_season = 1L, timing = 0,
  figure = TRUE)
}
\arguments{
\item{MLZ_data}{An object of class \code{\linkS4class{MLZ_data}} containing mean lengths and
life history data of stock.}

\item{start}{A list of starting values. Names of start list must contain \code{q} and \code{M}.}

\item{n_age}{The number of ages above age tc in the model.}

\item{estimate.M}{If \code{TRUE}, natural mortality (M) will be estimated. Otherwise, the value of M
is obtained from slot \code{MLZ_data@M}.}

\item{log.par}{Whether parameters are estimated in logspace (\code{TRUE}) or untransformed space (\code{FALSE}).}

\item{eff_init}{The assumed equilibrium effort prior to the first year of the model (0 = virgin conditions).}

\item{n_season}{The number of seasons modeled in a year.}

\item{obs_season}{The season corresponding to the observed mean lengths.}

\item{timing}{The fraction of time (i.e., between 0 - 1) within \code{obs_season} that mean lengths are observed.}

\item{figure}{If \code{TRUE}, a call to \code{plot} of observed and predicted mean lengths will be produced.}
}
\value{
An object of class \code{\linkS4class{MLZ_model}}.
}
\description{
Estimator of fishing and natural mortality from a time series of mean length and effort data.
}
\examples{
\dontrun{
data(Nephrops)
Nephrops <- calc_ML(Nephrops, sample.size = FALSE)
res <- MLeffort(Nephrops, start = list(q = 0.1, M = 0.2),
                n_age = 24, eff_init = Nephrops@Effort[1])
}                
}
\references{
Then, A.Y, Hoenig, J.M, and Huynh, Q.C. In revision. Estimating fishing and natural
mortality rates, and catchability coefficient, from a series of observations on mean length and
fishing effort. ICES Journal of Marine Science.
}
