% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bposa.R
\name{bposa}
\alias{bposa}
\title{Bayesian analysis of generalized mixed linear model using MCMC}
\usage{
bposa(m, n, n.chains, data)
}
\arguments{
\item{m}{starting column number}

\item{n}{ending column number}

\item{n.chains}{number of MCMC chains}

\item{data}{dataset whose first row is the respective time points at which observations(integers) are taken
where timepoints are the respective column names,dimension have to be 26 by 3.}
}
\value{
posterior distribution result of the parameters
}
\description{
provides Bayesian analysis of generalized mixed linear model where the repeated measure(with missing value) has poisson distrbution
using MCMC
}
\details{
The model for this function is
\deqn{Y_{ij}\sim Poisson(\mu_{ij})}
with link function
\deqn{log(\mu_{ij}|b_{1i},b_{2i})=\beta_1+\beta_2t_j+b_{1i}+b_{2i}t_j}
where the \eqn{b_{1i},b_{2i}}, i = 1,2,…,N are independent and have a two-dimensional
normal distribution with a 2 by 1 mean vector 0 and unknown 2 by 2 covariance matrix \eqn{\Sigma}
}
\examples{
##
data(catdata)
bposa(m=1,n=2,n.chains=1,data=catdata)
##
}
\references{
Broemeling, Lyle D. Bayesian methods for repeated measures. CRC Press, 2015.
}
\author{
Atanu Bhattacharjee,Bhrigu Kumar Rajbongshi and Gajendra K Vishwakarma
}
