% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCtrace.R
\name{MCMCtrace}
\alias{MCMCtrace}
\title{Trace and density plots from MCMC output}
\usage{
MCMCtrace(object, params = "all", excl = NULL, iter = 2000, pdf = FALSE,
  filename, wd = getwd(), type = "both", ind = FALSE)
}
\arguments{
\item{object}{Object containing MCMC output. See DETAILS below.}

\item{params}{Character string (or vector of character strings) denoting parameters of interest.
Partial names may be used to return all parameters containing that set of characters.

Default \code{'all'} returns chains for all parameters.}

\item{excl}{Character string (or vector of character strings) denoting parameters to exclude.
Partial names may be used to exclude all parameters containing that set of characters. Used in
conjunction with \code{params} argument to select parameters of interest.}

\item{iter}{Number of iterations to plot for trace and density plots. The default value is 2000,
meaning the last 2000 iterations of the chain will be plotted.}

\item{pdf}{Logical - if \code{pdf = TRUE} plots will be exported to a pdf.}

\item{filename}{Name of pdf file to be printed.}

\item{wd}{Working directory for pdf output. Default is current directory.}

\item{type}{Type of plot to be output. \code{'both'} outputs both trace and density plots, \code{'trace'}
outputs only trace plots, and \code{'density'} outputs only density plots.}

\item{ind}{Logical - if \code{ind = TRUE}, different lines will be plotted for each chain. If
\code{ind= FALSE}, one line will be plotted for all chains.}
}
\description{
Trace and density plots of MCMC chains for specific parameters of interest. Option to
print plots to pdf.
}
\section{Details}{

\code{object} argument can be a \code{stanfit} object (\code{rstan} package), an \code{mcmc.list} object
(\code{coda} package), or an \code{R2jags} model object (\code{R2jags} package). The function automatically
detects the object type and proceeds accordingly.
}

\examples{
#Load data
data(MCMC_data)

#Traceplot for all 'beta' parameters
MCMCtrace(MCMC_data, params='beta')

#Print traceplot output to pdf
MCMCtrace(MCMC_data, pdf= TRUE, filename = 'PDF_file.pdf')

}
