% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VIKOR.R
\name{VIKOR}
\alias{VIKOR}
\title{VIKOR method}
\usage{
VIKOR(
  performanceTable,
  criteriaWeights,
  criteriaMinMax,
  v = 0.5,
  positiveIdealSolutions = NULL,
  negativeIdealSolutions = NULL,
  alternativesIDs = NULL,
  criteriaIDs = NULL
)
}
\arguments{
\item{performanceTable}{Information matrix with nAlt rows and nCrit columns. 
Values correspond to the level the corresponding criteria takes for the 
corresponding alternative. All values should be numeric. Rows and columns
should be named as the alternatives and criteria, respectively.}

\item{criteriaWeights}{Numeric vector with nCrit elements. Should be named.}

\item{criteriaMinMax}{Character vector with nCrit elements. It should 
contain values "min" if the corresponding criteria is to be minimised (less 
is better), or "max" if the corresponding criteria is to be maximised (more 
is better).}

\item{v}{Numeric scalar. Parameter defining the importance given to the group
utility, with respect to the minimun regret of the opponent alternative. 
Should be between 0 and 1. Default is 0.5.}

\item{positiveIdealSolutions}{Numeric vector of ideal criteria values. If 
omitted, then they are defined as the best values observed among the 
existing alternatives.}

\item{negativeIdealSolutions}{Numeric vector of worst possible criteria 
values. If omitted, then they are defined as the worst values observed among 
the existing alternatives.}

\item{alternativesIDs}{Character vector. Name of the alternatives to consider
in the evaluation. If omitted, all alternatives in performanceTable are used.}

\item{criteriaIDs}{Character vector. Name of the criteria to consider 
in the evaluation. If omitted, all criteria in performanceTable are used.}
}
\value{
The function returns a vector containing the VIKOR score for each
alternative.
}
\description{
VIKOR is a multi-criteria decision analysis method originally developed by 
Serafim Opricovic in his 1979 Ph.D. Thesis, and later published in 1998.
}
\examples{
alts <- c("Corsa","Clio","Fiesta")
crit <- c("price","economy", "aesthetics","bootCapacity")
performanceTable <- matrix(c(5490, 51.4, 8.5, 285,
                             6500, 70.6, 7.0, 288,
                             6489, 54.3, 7.5, 290), 
                             nrow=3, ncol=4, byrow=TRUE, 
                             dimnames=list(alts, crit))
criteriaWeights <- setNames(c(0.35,0.25,0.25,0.15), crit)
criteriaMinMax  <- setNames(c("min", "max", "max", "max"), crit)
positiveIdealSolutions <- setNames(c(4500, 80, 9, 300), crit)
negativeIdealSolutions <- setNames(c(7000, 52, 7, 150), crit)

# Overall
VIKOR(performanceTable, criteriaWeights, criteriaMinMax)
# Assuming different ideal and worst solutions
VIKOR(performanceTable, criteriaWeights, criteriaMinMax,
      v=0.5, positiveIdealSolutions, negativeIdealSolutions)
# Using a subset of alternatives and criteria
VIKOR(performanceTable, criteriaWeights, criteriaMinMax,
      v=0.5, positiveIdealSolutions, negativeIdealSolutions,
      alternativesIDs = c("Clio","Fiesta"),
      criteriaIDs = c("price","economy","aesthetics"))
}
\references{
Opricovic, S. (1998). Multicriteria optimization of civil 
engineering systems. Faculty of civil engineering, Belgrade, 2(1), 5-21.
}
