% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dose.functions.R
\name{dexp}
\alias{dexp}
\title{Exponential dose-response function}
\usage{
dexp(emax = "rel", onset = NULL)
}
\arguments{
\item{emax}{Pooling for Emax  parameter. Can take \code{"rel"}, \code{"common"}, \code{"random"} or be
assigned a numeric value (see details).}

\item{onset}{Pooling for onset parameter. Can take \code{"rel"}, \code{"common"}, \code{"random"} or be
assigned a numeric value (see details).}
}
\value{
An object of \code{class("dosefun")}
}
\description{
Similar parameterisation to the Emax model but with non-asymptotic maximal effect (Emax). Can fit
a 1-parameter (Emax only) or 2-parameter model (includes onset parameter that controls the curvature of
the dose-response relationship)
}
\details{
1-parameter model:
\eqn{emax\times{(1-exp(-x))}}

2-parameter model:
\eqn{emax\times{(1-exp(exp(onset)*-x))}}

where emax is the maximum efficacy of an agent and rate is the speed

Dose-response parameter arguments:\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"rel"} \tab Implies that \emph{relative} effects should be pooled for this dose-response parameter separately for each agent in the network. \cr
   \code{"common"} \tab Implies that all agents share the same common effect for this dose-response parameter. \cr
   \code{"random"} \tab Implies that all agents share a similar (exchangeable) effect for this dose-response parameter. This approach allows for modelling of variability between agents. \cr
   \code{numeric()} \tab Assigned a numeric value, indicating that this dose-response parameter should not be estimated from the data but should be assigned the numeric value determined by the user. This can be useful for fixing specific dose-response parameters (e.g. Hill parameters in Emax functions) to a single value. \cr
}
}
\examples{
# Single parameter exponential function is default
dexp()

# Two parameter exponential function
dexp(onset="rel")

}
\references{
\insertAllCited
}
