% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_03_COMPUTE_PSI_6_Compute_ALE.R
\name{ComputePSI.ALE}
\alias{ComputePSI.ALE}
\title{Compute alternative last exon (ALE) percent spliced-in (PSI) values}
\usage{
ComputePSI.ALE(MarvelObject, CoverageThreshold = 10)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{DetectEvents} function.}

\item{CoverageThreshold}{Numeric value. Coverage threshold below which the PSI of the splicing event will be censored, i.e. annotated as missing (NA). Coverage defined as the total number of reads supporting both included and excluded isoforms.}
}
\value{
An object of class S3 containing with new slots \code{$SpliceFeatureValidated$ALE} and \code{$PSI$ALE}.
}
\description{
Computes percent spliced-in (PSI) for alternative last exon (ALE) splicing events.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- ComputePSI.ALE(MarvelObject=marvel.demo,
                              CoverageThreshold=10
                              )
}
