% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_05_2_PlotValues_Exp.R
\name{PlotValues.Exp}
\alias{PlotValues.Exp}
\title{Plot Gene Expression Values}
\usage{
PlotValues.Exp(MarvelObject, cell.types, feature, maintitle = NULL)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CreateMarvelObject} or \code{ComputePSI} function.}

\item{cell.types}{Character string. To indicate which groups of cells that will be used for plotting. Group names should match those in \code{cell.type} column of \code{$GenePheno} slot.}

\item{feature}{Character string. \code{gene_id} for plotting. Should match \code{gene_id} column of \code{$GeneFeature} slot.}

\item{maintitle}{Character string. Column to use as plot main title as per \code{GeneFeature}.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new slot named \code{$adhocPlot$Gene}.
}
\description{
\code{PlotValues.Exp} plots gene expression values across different groups of cells.
}
\details{
This function plots gene expression values across different groups of cells. Boxplot is used for gene expression values.
}
\examples{
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

feature <- marvel$GeneFeature$gene_id[1]

marvel <- PlotValues.Exp(MarvelObject=marvel,
                         cell.types=c("iPSC", "Endoderm"),
                         feature=feature,
                         maintitle="gene_short_name"
                         )

marvel$adhocPlot$Gene
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
