% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum.Analysis-class.R
\docType{class}
\name{RLum.Analysis-class}
\alias{RLum.Analysis-class}
\alias{show,RLum.Analysis-method}
\alias{set_RLum,RLum.Analysis-method}
\alias{get_RLum,RLum.Analysis-method}
\alias{structure_RLum,RLum.Analysis-method}
\alias{length_RLum,RLum.Analysis-method}
\alias{names_RLum,RLum.Analysis-method}
\alias{smooth_RLum,RLum.Analysis-method}
\title{Class \code{"RLum.Analysis"}}
\usage{
\S4method{show}{RLum.Analysis}(object)

\S4method{set_RLum}{RLum.Analysis}(class, originator, .uid, .pid,
  protocol = NA_character_, records = list(), info = list())

\S4method{get_RLum}{RLum.Analysis}(object, record.id = NULL,
  recordType = NULL, curveType = NULL, RLum.type = NULL,
  protocol = "UNKNOWN", get.index = NULL, drop = TRUE,
  recursive = TRUE, info.object = NULL, subset = NULL,
  env = parent.frame(2))

\S4method{structure_RLum}{RLum.Analysis}(object, fullExtent = FALSE)

\S4method{length_RLum}{RLum.Analysis}(object)

\S4method{names_RLum}{RLum.Analysis}(object)

\S4method{smooth_RLum}{RLum.Analysis}(object, ...)
}
\arguments{
\item{object}{\code{\link{get_RLum}}: \code{\link{names_RLum}}, \code{\link{length_RLum}}, \code{\link{structure_RLum}} (\strong{required}):
an object of class \linkS4class{RLum.Analysis}}

\item{class}{\code{\link{set_RLum}} \link{character} (\strong{required}):
name of the \code{RLum} class to be created}

\item{originator}{\code{\link{set_RLum}} \link{character} (\emph{automatic}):
contains the name of the calling function (the function that produces this object);
can be set manually.}

\item{.uid}{\code{\link{set_RLum}} \link{character} (\emph{automatic}):
sets an unique ID for this object using the internal C++ function \code{create_UID}.}

\item{.pid}{\code{\link{set_RLum}} \link{character} (\emph{with default}):
option to provide a parent id for nesting at will.}

\item{protocol}{\code{\link{set_RLum}} \link{character} (\emph{optional}):
sets protocol type for analysis object. Value may be used by subsequent analysis functions.}

\item{records}{\code{\link{set_RLum}} \link{list} (\strong{required}):
list of \linkS4class{RLum.Analysis} objects}

\item{info}{\code{\link{set_RLum}} \link{list} (\emph{optional}):
a list containing additional info data for the object

\strong{\code{set_RLum}}:

Returns an \linkS4class{RLum.Analysis} object.}

\item{record.id}{\code{\link{get_RLum}}: \link{numeric} or \link{logical} (\emph{optional}):
IDs of specific records. If of type \code{logical} the entire id range is assumed
and \code{TRUE} and \code{FALSE} indicates the selection.}

\item{recordType}{\code{\link{get_RLum}}: \link{character} (\emph{optional}):
record type (e.g., "OSL"). Can be also a vector, for multiple matching,
e.g., \code{recordType = c("OSL", "IRSL")}}

\item{curveType}{\code{\link{get_RLum}}: \link{character} (\emph{optional}):
curve type (e.g. "predefined" or "measured")}

\item{RLum.type}{\code{\link{get_RLum}}: \link{character} (\emph{optional}):
RLum object type. Defaults to "RLum.Data.Curve" and "RLum.Data.Spectrum".}

\item{get.index}{\code{\link{get_RLum}}: \link{logical} (\emph{optional}):
return a numeric vector with the index of each element in the RLum.Analysis object.}

\item{drop}{\code{\link{get_RLum}}: \link{logical} (\emph{with default}):
coerce to the next possible layer (which are \code{RLum.Data}-objects),
\code{drop = FALSE} keeps the original \code{RLum.Analysis}}

\item{recursive}{\code{\link{get_RLum}}: \link{logical} (\emph{with default}):
if \code{TRUE} (the default) and the result of the 'get_RLum' request is a single
object this object will be unlisted, means only the object itself and no
list containing exactly one object is returned. Mostly this makes things
easier, however, if this method is used within a loop this might be undesired.}

\item{info.object}{\code{\link{get_RLum}}: \link{character} (\emph{optional}):
name of the wanted info element}

\item{subset}{\code{\link{get_RLum}}: \link{expression} (\emph{optional}):
logical expression indicating elements or rows to keep: missing values are
taken as false. This argument takes precedence over all other arguments,
meaning they are not considered when subsetting the object.}

\item{env}{\code{\link{get_RLum}}: \link{environment} (\emph{with default}):
An environment passed to \link{eval} as the enclosure. This argument is only
relevant when subsetting the object and should not be used manually.}

\item{fullExtent}{\link{structure_RLum}; \link{logical} (\emph{with default}):
extents the returned \code{data.frame} to its full extent, i.e. all info elements
are part of the return as well. The default value is \code{FALSE} as the data
frame might become rather big.}

\item{...}{further arguments passed to underlying methods}
}
\value{
\strong{\code{get_RLum}}:

Returns:
\enumerate{
\item \link{list} of \linkS4class{RLum.Data} objects or
\item Single \linkS4class{RLum.Data} object, if only one object is contained and \code{recursive = FALSE} or
\item \linkS4class{RLum.Analysis} ojects for \code{drop = FALSE}
}

\strong{\code{structure_RLum}}:

Returns \linkS4class{data.frame} showing the structure.

\strong{\code{length_RLum}}

Returns the number records in this object.

\strong{\code{names_RLum}}

Returns the names of the record types (\code{recordType}) in this object.

\strong{\code{smooth_RLum}}

Same object as input, after smoothing
}
\description{
Object class to represent analysis data for protocol analysis, i.e. all curves,
spectra etc. from one measurements. Objects from this class are produced,
by e.g. \link{read_XSYG2R}, \link{read_Daybreak2R}
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Show structure of \code{RLum.Analysis} object

\item \code{set_RLum}: Construction method for \linkS4class{RLum.Analysis} objects.

\item \code{get_RLum}: Accessor method for RLum.Analysis object.

The slots record.id, recordType, curveType and RLum.type are optional to allow for records
limited by their id (list index number), their record type (e.g. recordType = "OSL")
or object type.

Example: curve type (e.g. curveType = "predefined" or curveType ="measured")

The selection of a specific RLum.type object superimposes the default selection.
Currently supported objects are: RLum.Data.Curve and RLum.Data.Spectrum

\item \code{structure_RLum}: Method to show the structure of an \linkS4class{RLum.Analysis} object.

\item \code{length_RLum}: Returns the length of the object, i.e., number of stored records.

\item \code{names_RLum}: Returns the names of the \linkS4class{RLum.Data} objects objects (same as shown with the show method)

\item \code{smooth_RLum}: Smoothing of \code{RLum.Data} objects contained in this \code{RLum.Analysis} object
\link[zoo:rollmean]{zoo::rollmean} or \link[zoo:rollmean]{zoo::rollmedian}. In particular the internal
function \code{.smoothing} is used.
}}

\section{Slots}{

\describe{
\item{\code{protocol}}{Object of class \link{character} describing the applied measurement protocol}

\item{\code{records}}{Object of class \link{list} containing objects of class \linkS4class{RLum.Data}}
}}

\note{
The method \link{structure_RLum} is currently just avaiblable for objects
containing \linkS4class{RLum.Data.Curve}.
}
\section{Objects from the Class}{

Objects can be created by calls of the form \code{set_RLum("RLum.Analysis", ...)}.
}

\section{Class version}{
 0.4.15
}

\examples{

showClass("RLum.Analysis")

##set empty object
set_RLum(class = "RLum.Analysis")

###use example data
##load data
data(ExampleData.RLum.Analysis, envir = environment())

##show curves in object
get_RLum(IRSAR.RF.Data)

##show only the first object, but by keeping the object
get_RLum(IRSAR.RF.Data, record.id = 1, drop = FALSE)

}
\seealso{
\link{Risoe.BINfileData2RLum.Analysis},
\linkS4class{Risoe.BINfileData}, \linkS4class{RLum}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, UMR 5060, CNRS - Université Bordeaux Montaigne (France)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2019. RLum.Analysis-class(): Class 'RLum.Analysis'. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., 2019. Luminescence: Comprehensive Luminescence Dating Data AnalysisR package version 0.9.2. https://CRAN.R-project.org/package=Luminescence
}

\keyword{classes}
\keyword{internal}
\keyword{methods}
