% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Luminescence-package.R
\docType{package}
\name{Luminescence-package}
\alias{Luminescence}
\alias{Luminescence-package}
\title{Comprehensive Luminescence Dating Data Analysis}
\description{
A collection of various R functions for the purpose of Luminescence dating
data analysis. This includes, amongst others, data import, export,
application of age models, curve deconvolution, sequence analysis and
plotting of equivalent dose distributions.
}
\details{
\tabular{ll}{ Package: \tab Luminescence\cr Type: \tab Package\cr Version:
\tab 0.4.5\cr Date: \tab 2015-08-10\cr License: \tab GPL-3\cr }
}
\author{
\bold{Authors}

\tabular{ll}{ Christoph Burow \tab University of Cologne, Germany \cr
Michael Dietze \tab GFZ Helmholtz Centre Potsdam, Germany \cr Manfred
Fischer\tab University of Bayreuth, Germany \cr Margret C. Fuchs \tab
Helmholtz-Zentrum Dresden-Rossendorf, Helmholtz-Institute Freiberg for Resource Technology,
Freiberg, Germany \cr
Sebastian Kreutzer \tab IRAMAT-CRP2A, Universite Bordeaux Montaigne, Pessac,
France\cr Christoph Schmidt \tab University of Bayreuth, Germany\cr Rachel
K. Smedley\tab Aberystwyth University, United Kingdom }

\bold{Beta-Tester}

Thomas Kolb, University of Bayreuth, Germany\cr

\bold{Supervisor}

Markus Fuchs, Justus-Liebig-University Giessen, Germany\cr

\bold{Support contact}

\email{developer@r-luminescence.de}\cr

We may further encourage the usage of our support forum. For this please
visit our project website (link below).

\bold{Bug reporting}

\email{bugtracker@r-luminescence.de} \cr

\bold{Project website}

\url{http://www.r-luminescence.de}\cr

\bold{Project source code repository}\cr
\url{https://github.com/R-Lum/Luminescence}\cr

\bold{Related package projects}\cr
\url{http://cran.r-project.org/package=RLumShiny}\cr
\url{http://shiny.r-luminescence.de}\cr

\bold{Package maintainer}

Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne, Pessac,
France, \cr \email{sebastian.kreutzer@u-bordeaux-montaigne.fr}

\bold{Acknowledgement}

Cooperation and personal exchange between the developers is gratefully
funded by the DFG (SCHM 3051/3-1) in the framework of the program
"Scientific Networks". Project title: "Lum.Network: Ein
Wissenschaftsnetzwerk zur Analyse von Lumineszenzdaten mit R" (2014-2017)
}
\references{
Dietze, M., Kreutzer, S., Fuchs, M.C., Burow, C., Fischer, M.,
Schmidt, C., 2013. A practical guide to the R package Luminescence.  Ancient
TL, 31, pp. 11-18.

Fuchs, M.C., Kreutzer, S., Burow, C., Dietze, M., Fischer, M., Schmidt, C.,
Fuchs, M., 2015. Data processing in luminescence dating analysis: An
exemplary workflow using the R package 'Luminescence'. Quaternary
International, 362, pp. 8-13. http://dx.doi.org/10.1016/j.quaint.2014.06.034

Kreutzer, S., Schmidt, C., Fuchs, M.C., Dietze, M., Fischer, M., Fuchs, M.,
2012. Introducing an R package for luminescence dating analysis. Ancient TL,
30, pp. 1-8.
}
\keyword{package}

