% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GA-call.R
\name{Lorenz.ga.call}
\alias{Lorenz.ga.call}
\title{Call to the genetic algorithm for the Lorenz regression}
\usage{
Lorenz.ga.call(
  ties.method,
  y,
  x,
  pi,
  V,
  popSize,
  maxiter,
  run,
  parallel.GA,
  suggestions,
  seed = NULL
)
}
\arguments{
\item{ties.method}{Either \code{"mean"} or \code{"random"}.}

\item{y}{vector of responses.}

\item{x}{matrix of covariates.}

\item{pi}{sample weights (normalized).}

\item{V}{vector of uniformly distributed rvs.}

\item{popSize}{passed to \code{ga}.}

\item{maxiter}{passed to \code{ga}.}

\item{run}{passed to \code{ga}.}

\item{parallel.GA}{passed to \code{ga}.}

\item{suggestions}{passed to \code{ga}.}

\item{seed}{An optional integer for setting the seed for random number generation. Default is \code{NULL}.}
}
\value{
The fitted genetic algorithm
}
\description{
\code{Lorenz.ga.call} encapsulates the call to ga for a local management of seed setting
}
\keyword{internal}
