% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcor.R
\name{lcor}
\alias{lcor}
\title{Rearrange columns in a data-frame to fit a predefined correlation matrix}
\usage{
lcor(data, target)
}
\arguments{
\item{data}{beginning data-frame that is to be rearranged}

\item{target}{target correlation matrix - should be a symmetric
(square) k*k matrix}
}
\value{
Returns a data-frame whose column-wise correlations
approximate a user-specified correlation matrix
}
\description{
\code{lcor()} rearranges values in each column of a
data-frame so that columns are correlated to match a predefined
correlation matrix.
}
\details{
Values in a column do not change, so univariate
statistics remain the same.
}
\examples{

## generate uncorrelated synthetic data

n <- 32
x1 <- lfast(n, 3.5, 1.0, 1, 5, 5)
x2 <- lfast(n, 1.5, 0.75, 1, 5, 5)
x3 <- lfast(n, 3.0, 2.0, 1, 5, 5)

mydat3 <- cbind(x1, x2, x3) |> data.frame()

cor(mydat3)

## describe a target correlation matrix
tgt3 <- matrix(
  c(
    1.00, 0.50, 0.75,
    0.50, 1.00, 0.25,
    0.75, 0.25, 1.00
  ),
  nrow = 3
)

## apply lcor function
new3 <- lcor(mydat3, tgt3)

cor(new3) |> round(3)

}
