% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_heatmap.R
\name{gg_heatmap}
\alias{gg_heatmap}
\title{Plot a heatmap across days and times of day}
\usage{
gg_heatmap(
  dataset,
  Variable.colname = MEDI,
  Datetime.colname = Datetime,
  unit = "1 hour",
  doubleplot = c("no", "same", "next"),
  date.title = "Date",
  date.breaks = 1,
  date.labels = "\%d/\%m",
  time.title = "Local time (HH:MM)",
  time.breaks = hms::hms(hours = seq(0, 48, by = 6)),
  time.labels = "\%H:\%M",
  fill.title = "Illuminance\\n(lx, mel EDI)",
  fill.scale = "symlog",
  fill.labels = function(x) format(x, scientific = FALSE, big.mark = " "),
  fill.breaks = c(-10^(5:0), 0, 10^(0:5)),
  fill.limits = c(0, 10^5),
  fill.remove = FALSE,
  ...
)
}
\arguments{
\item{dataset}{A light dataset}

\item{Variable.colname}{The column name of the variable to display. Defaults
to \code{MEDI}. Expects a symbol.}

\item{Datetime.colname}{The column name of the datetime column. Defaults to
\code{Datetime}. Expects a symbol.}

\item{unit}{level of aggregation for \code{Variable.colname}. Defaults to \code{"1 hour"}. Expects a duration or duration-coercible value}

\item{doubleplot}{Should the data be plotted as a doubleplot. Default is
"no". "next" will plot the respective next day after the first, "same" will
plot the same day twice.}

\item{date.title}{Title text of the y-axis. Defaults to \code{Date}}

\item{date.breaks}{Spacing of date breaks. Defaults to \code{1} (every day)}

\item{date.labels}{Formatting code of the date labels}

\item{time.title}{Title text of the x-axis. Defaults to \verb{Local time (HH:MM)}}

\item{time.breaks}{Spacing of time breaks. Defauls to every six hours.}

\item{time.labels}{Formatting code of the time labels}

\item{fill.title}{Title text of the value (fill) scale.}

\item{fill.scale}{Scaling of the value (fill) scale. Defaults to \code{"symlog"}
(see \code{\link[=symlog_trans]{symlog_trans()}})}

\item{fill.labels}{Formula to format the label values.}

\item{fill.breaks}{Breaks in the fill scale}

\item{fill.limits}{Limits of the fill scale. A length-2 numeric with the
lower and upper scale. If one is replaced with \code{NA}, this limit will be
based on the data.}

\item{fill.remove}{Logical. Should the fill scale be removed? Handy when the
fill scale is to be replaced by another scale without the console messages
warning about existing scale}

\item{...}{Other arguments to provide to the underlying
\code{\link[ggplot2:geom_tile]{ggplot2::geom_raster()}}}
}
\value{
A ggplot object
}
\description{
This function plots a heatmap of binned values across the day over all days
in a group. It also allows doubleplot functionality. **\code{\link[=gg_heatmap]{gg_heatmap()}} does
not work with the additive functions \code{\link[=gg_photoperiod]{gg_photoperiod()}} and \code{\link[=gg_state]{gg_state()}}.
}
\details{
The function uses \code{\link[ggplot2:scale_viridis]{ggplot2::scale_fill_viridis_c()}} for the fill scale. The
scale can be substituted by any other scale via the standard \code{+} command of
ggplot2. It is recommended to set \code{fill.remove = TRUE} to reduce warnings.
}
\examples{
sample.data.environment |> gg_heatmap()

#heatmap with doubleplot
sample.data.environment |> gg_heatmap(doubleplot = "next")

#change the unit of aggregation
sample.data.environment |> gg_heatmap(unit = "5 mins")

#change the limits of the fill scale
sample.data.environment |> gg_heatmap(fill.limits = c(0, 10^4))
}
