% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw.to.par.R
\name{sw.to.par}
\alias{sw.to.par}
\alias{sw.to.par.base}
\title{Convert shortwave radiation to PAR}
\usage{
sw.to.par(data, sw.col='sw', coeff=2.114)

sw.to.par.base(sw, coeff=2.114)
}
\arguments{
\item{data}{Object of class data.frame with column name \code{sw} (or specified alternate)}

\item{sw.col}{Name of column containing shortwave data (units must be W/m^2)}

\item{coeff}{Numerical coefficient to convert SW (W/m^2) to PAR (umol/m^2/sec). 
Defaults to value from Britton and Dodd (1976).}

\item{sw}{Numeric shortwave value in W/m^2}
}
\value{
#For sw.to.par

Object of class data.frame with column name 'par' and other values from \code{ts.data}

#for sw.to.par.base

Numeric vector of PAR values in units umol/m^2/sec
}
\description{
Returns PAR by converting incoming shortwave radiation measuremt.
}
\examples{
#For base function
sw <- 800
sw.to.par.base(sw)

}
\author{
Luke Winslow and others
}
\references{
Britton, C. M., and J. D. Dodd. \emph{Relationships of photosynthetically active radiation and shortwave irradiance.} 
Agricultural Meteorology 17, no. 1 (1976): 1-7.
}
\seealso{
\link{par.to.sw}
}
\keyword{math}
\keyword{methods}

