% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_functions.R
\name{ddwell}
\alias{ddwell}
\title{State dwell-time distributions of periodically inhomogeneous Markov chains}
\usage{
ddwell(x, Gamma, time = NULL, state = NULL)
}
\arguments{
\item{x}{vector of (non-negative) dwell times to compute the dwell-time distribution for}

\item{Gamma}{array of \code{L} unique transition probability matrices of a periodically inhomogeneous Markov chain, with dimensions \code{c(N,N,L)}, where \code{N} is the number of states and \code{L} is the cycle length}

\item{time}{integer vector of time points in \code{1:L} at which to compute the dwell-time distribution. If \code{NULL}, the overall dwell-time distribution is computed.}

\item{state}{integer vector of state indices for which to compute the dwell-time distribution. If \code{NULL}, dwell-time distributions for all states are returned in a named list.}
}
\value{
either time-varying dwell-time distribution(s) if \code{time} is specified, or overall dwell-time distribution if \code{time} is \code{NULL}. 
If more than one \code{state} is specified, a named list over states is returned.
}
\description{
Computes the dwell-time distribution of a periodically inhomogeneous Markov chain for a given transition probability matrix.
}
\details{
For Markov chains whose transition probabilities vary only periodically, which is achieved for example by
expressing the transition probability matrix as a periodic function of the time of day using \code{\link{tpm_p}} or \code{\link{cosinor}}, the probability distribution of time spent in a state can be computed analytically.
This function computes said distribution, either for a specific time point (conditioning on transitioning into the state at that time point) or for the overall distribution (conditioning on transitioning into the state at any time point).
}
\examples{
# setting parameters for trigonometric link
beta = matrix(c(-1, 2, -1, -2, 1, -1), nrow = 2, byrow = TRUE)
Gamma = tpm_p(beta = beta, degree = 1)

# at specific times and for specific state
ddwell(1:20, Gamma, time = 1:4, state = 1)
# results in 4x20 matrix

# or overall distribution for all states
ddwell(1:20, Gamma)
# results in list of length 2, each element is a vector of length 20

}
\references{
Koslik, J. O., Feldmann, C. C., Mews, S., Michels, R., & Langrock, R. (2023). Inference on the state process of periodically inhomogeneous hidden Markov models for animal behavior. arXiv preprint arXiv:2312.14583.
}
