% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fxcat.R
\name{fxcat}
\alias{fxcat}
\title{Define Effect Category}
\usage{
fxcat(dat)
}
\arguments{
\item{dat}{A data frame of toxicity data, including at least two variables:
ntot (the number of individuals tested) and
nfx (the number of affected individuals).}
}
\value{
An integer vector the same length as \code{prob} with
    categories of 0, 50, or 100.
}
\description{
Define three effect categories, 0 for none affected, 100 for all affected,
  and 50 for other proportions affected.
}
\examples{
toxdat <- data.frame(
  dose=c(0.0625, 0.125, 0.25, 0.5),
  ntot=rep(8, 4),
  nfx = c(0, 4, 6, 8))
cbind(toxdat, fxcat(toxdat))
}
