% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GA.R
\name{GA}
\alias{GA}
\title{Genetic Algorithm for LHD}
\usage{
GA(
  n,
  k,
  m = 10,
  N = 10,
  pmut = 1/(k - 1),
  OC = "phi_p",
  p = 15,
  q = 1,
  maxtime = 5
)
}
\arguments{
\item{n}{A positive integer, which stands for the number of rows (or run size).}

\item{k}{A positive integer, which stands for the number of columns (or factor size).}

\item{m}{A positive even integer, which stands for the population size and it must be an even number. The default is set to be 10.}

\item{N}{A positive integer, which stands for the number of iterations. The default is set to be 10.}

\item{pmut}{A probability, which stands for the probability of mutation. The default is set to be 1/(\code{k} - 1).}

\item{OC}{An optimality criterion. The default setting is "phi_p", and it could be one of the following: "phi_p", "AvgAbsCor", "MaxAbsCor", "MaxProCriterion".}

\item{p}{A positive integer, which is the parameter in the phi_p formula, and \code{p} is prefered to be large. The default is set to be 15.}

\item{q}{The default is set to be 1, and it could be either 1 or 2. If \code{q} is 1, \code{dij} is the Manhattan (rectangular) distance. If \code{q} is 2, \code{dij} is the Euclidean distance.}

\item{maxtime}{A positive number, which indicates the expected maximum CPU time given by user, and it is measured by minutes. For example, maxtime=3.5 indicates the CPU time will be no greater than three and half minutes. The default is set to be 5.}
}
\value{
If all inputs are logical, then the output will be a \code{n} by \code{k} LHD.
}
\description{
\code{GA} returns an LHD matrix generated by genetic algorithm (GA)
}
\examples{
#generate a 5 by 3 maximin distance LHD with the default setting
try=GA(n=5,k=3)
try
phi_p(try)   #calculate the phi_p of "try".

#Another example
#generate a 8 by 4 nearly orthogonal LHD
try2=GA(n=8,k=4,OC="AvgAbsCor")
try2
AvgAbsCor(try2)  #calculate the average absolute correlation.
}
\references{
Liefvendahl, M., and Stocki, R. (2006) A study on algorithms for optimization of Latin hypercubes. \emph{Journal of Statistical Planning and Inference}, \strong{136}, 3231-3247.
}
