% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RD_for_LA_OofA.R
\name{LA_OofAC}
\alias{LA_OofAC}
\alias{factorialC}
\alias{modC}
\alias{rOofAC}
\alias{PWOC}
\alias{TC}
\alias{MOMC}
\title{Lioness Algorithm for order-of-addition design}
\usage{
LA_OofAC(n, k, m = 100L, N = 5000L)

factorialC(x)

modC(a, b)

rOofAC(n, k)

PWOC(X)

TC(X)

MOMC(X)
}
\arguments{
\item{n}{A positive integer, which stands for the number of rows (or run size). Note that the maximum of \code{n} cannot be greater than \code{k} factorial.}

\item{k}{A positive integer, which stands for the number of columns (or factor size).}

\item{m}{A positive integer, which stands for the number of starting lionesses agents. The default is set to be 100.}

\item{N}{A positive integer, which stands for the number of iterations. The default is set to be 5000. A large value of \code{N} will result a high CPU time.}

\item{x}{is a positive integer.}

\item{a}{is a positive integer.}

\item{b}{is a positive integer.}

\item{X}{A matrix object. In general, \code{X} stands for the design matrix.}
}
\value{
If all inputs are logical, then the output will be a \code{n} by \code{k} order-of-addition design.
}
\description{
\code{LA_OofAC} returns a \code{n} by \code{k} D-optimal order-of-addition design matrix generated by lioness algorithm (LA)
}
\examples{
#generate a D-optimal full OofA with 4 factors.
try=LA_OofAC(n=24,k=4,m=10,N=50)
try

#Another example
#generate a D-optimal 11-run OofA with 4 factors.
try2=LA_OofAC(n=11,k=4,m=10,N=50)
try2
}
