% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FKM_Null_Model.R
\name{FKM_Null_Model}
\alias{FKM_Null_Model}
\title{KM for continuous Traits in Familial GWAS Data (fit null model)}
\usage{
FKM_Null_Model(phenotype, id, fa, mo, covariates = NULL)
}
\arguments{
\item{phenotype}{A vector of quantitative trait in the analysis (class: vector). The order should match the vector id. Subjects with missing phenotypes are only used for kinship calculation.}

\item{id}{A vector of id (class: vector). It can be either numeric or character. The id indicates each subject. Make sure it is not factor. No missing.}

\item{fa}{A vector of father id (class: vector). It can be either numeric or character. The father id indicates the father of each subject. If this subject has no father in this data, the value is set to "NA". Make sure it is not factor.}

\item{mo}{A vector of mother id (class: vector). It can be either numeric or character. The mother id indicates the mother of each subject. If this subject has no mother in this data, the value is set to "NA". Make sure it is not factor.}

\item{covariates}{A matrix of covariates (class: data.frame). The order of rows should match the vector id. Default NULL. Subjects with missing covariates are only used for kinship calculation.}
}
\value{
output: object as input for FKM
}
\description{
This function (FKM) is used to perform famSKAT analysis (Chen et al., 2013) for continuous traits in familial GWAS data \cr
# In the final correlation matrix, the covariance between parent and offspring is 0.5, the covariance between siblings is also 0.5
}
