% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkedLR.R
\name{linkedLR}
\alias{linkedLR}
\title{LR with pairwise linked markers}
\usage{
linkedLR(pedigrees, linkageMap, markerData = NULL, mapfun = "Kosambi")
}
\arguments{
\item{pedigrees}{A list of two pedigrees.}

\item{linkageMap}{A data frame with columns including \code{Pair}, \code{Marker},
\code{Chrom}, \code{PosCM}}

\item{markerData}{A data frame, normally extracted automatically from
\code{pedigrees}.}

\item{mapfun}{Name of the map function to be used; either "Haldane" or
"Kosambi" (default)}
}
\value{
A data frame with detailed LR results.
}
\description{
This function does the main LR calculations of the KLINK app.
}
\examples{
library(forrel)

ped1 = nuclearPed(fa = "AF", child = "CH") |>
  profileSim(markers = NorwegianFrequencies)

ped2 = singletons(c("AF", "CH")) |>
  transferMarkers(from = ped1, to = _)

pedigrees = list(ped1, ped2)

linkedLR(pedigrees, LINKAGEMAP)

}
