% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvInnovations.R
\name{mvInnovations}
\alias{mvInnovations}
\title{Multivariate Innovations}
\usage{
mvInnovations(x)
}
\arguments{
\item{x}{Object of class \code{KFS}.}
}
\value{
\item{v}{Multivariate prediction errors \eqn{v_{t} = y_{t} - Z_{t}a_{t}
}{v[t,i] = y[t] - Z[t]a[t]}}
\item{F}{Prediction error variances \eqn{Var(v_{t})}{Var(v[t])}. }
\item{Finf}{Diffuse part of \eqn{F_t}{F[t]}.}
}
\description{
Function \code{mvInnovations} computes the multivariate versions of one 
step-ahead prediction errors and their variances using the output of \code{\link{KFS}}.
}
\examples{

# Compute the filtered estimates based on the KFS output

filtered <- function(x) {
  innov <- mvInnovations(x)
  att <- window(x$a, end = end(x$a) - 1)
  tvz <- attr(x$model,"tv")[1]
  
  for (i in 1:nrow(att)) {
    att[i,] <- att[i,] + 
      x$P[,,i] \%*\% 
      t(solve(innov$F[,,i], x$model$Z[, , tvz * (i - 1) + 1, drop = FALSE])) \%*\%
      innov$v[i, ]
  }
  att
}
}

