% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jdmbs.R
\name{normal_bs}
\alias{normal_bs}
\title{A Normal Monte Carlo Option Pricing Algorithm}
\usage{
normal_bs(companies, simulation.length = 180, monte_carlo = 1000,
  start_price = start_price, mu = mu, sigma = sigma, K = K,
  color = color)
}
\arguments{
\item{companies}{: an integer of a company number in order to simulate.}

\item{simulation.length}{: an integer of a time duration of simulation.}

\item{monte_carlo}{: an integer of an iteration number for monte carlo.}

\item{start_price}{: a vector of company's initial stock prices.}

\item{mu}{: a vector of drift parameters of geometric Brownian motion.}

\item{sigma}{: a vector of volatility parameters of geometric Brownian motion.}

\item{K}{: a vector of option strike prices.}

\item{color}{: a vector of colors in plot.}
}
\value{
option prices : a list of (call_price, put_price)
}
\description{
A Normal Monte Carlo Option Pricing Algorithm
}
\examples{
price <- normal_bs(1, simulation.length=50, monte_carlo=100,1000, 0.007, 0.03, 1500, "blue")
}
