% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JacobiR.R
\name{Jacobi}
\alias{Jacobi}
\title{The Jacobi Algorithm using Rcpp}
\usage{
Jacobi(x, symmetric = TRUE, only.values = FALSE, eps = 0)
}
\arguments{
\item{x}{A real symmetric matrix}

\item{symmetric}{a logical value.  Is the matrix symmetric?  (Only symmetric matrices are allowed.)}

\item{only.values}{A logical value: do you want only the eigenvalues?}

\item{eps}{an error tolerance. 0.0 implies \code{.Machine$double.eps} and
\code{sqrt(.Machine$double.eps)} if \code{only.values = TRUE}}
}
\value{
a list of two components as for \code{base::eigen}
}
\description{
The Classical Jacobi Algorithm
}
\details{
Eigenvalues and optionally, eigenvectore, of a real symmetric matrix using the
classical Jacobi algorithm, (Jacobi, 1854)
}
\examples{
V <- crossprod(matrix(runif(40, -1, 1), 8))
Jacobi(V)
identical(Jacobi(V), JacobiR(V))
all.equal(Jacobi(V)$values, base::eigen(V)$values)
}
