% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangling_dataset_milestones.R
\name{format_milestones}
\alias{format_milestones}
\title{Format the milestones in a simpler format}
\usage{
format_milestones(raw_milestones, verbose = TRUE)
}
\arguments{
\item{raw_milestones}{a \code{gh_response} object output from the function
\code{\link[gh]{gh}} which contains all the data and metadata for GitHub
milestones.}

\item{verbose}{A logical value indicating whether to print additional
information. Default is \code{TRUE}.}
}
\value{
a list representing milestones with simpler structure (with title,
description and due_on)
}
\description{
Format the milestones in a simpler format
}
\examples{

\donttest{
# With milestones
milestones_jdplus_main <- gh::gh(
    repo = "jdplus-main",
    owner = "jdemetra",
    endpoint = "/repos/:owner/:repo/milestones",
    state = "all",
    .limit = Inf
 )
format_milestones(milestones_jdplus_main)
}

}
