% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discordia.R
\name{discordia.age}
\alias{discordia.age}
\title{Linear regression on a U-Pb concordia diagram}
\usage{
discordia.age(x, wetherill = TRUE, dcu = TRUE)
}
\arguments{
\item{x}{an object of class \code{UPb}}

\item{wetherill}{boolean flag to indicate whether the data should
be evaluated in Wetherill (\code{TRUE}) or Tera-Wasserburg
(\code{FALSE}) space}

\item{dcu}{propagate the decay constant uncertainties?}
}
\value{
a list with the following items:

\code{x}: a two element vector with the upper and lower intercept
ages (if wetherill==TRUE) or the lower intercept age and
\eqn{^{207}}Pb/\eqn{^{206}}Pb intercept (for Tera-Wasserburg)

\code{cov}: the covariance matrix of the elements in \code{x}
}
\description{
Performs linear regression of U-Pb data on Wetherill and
Tera-Wasserburg concordia diagrams. Computes the upper and lower
intercept ages (for Wetherill) or the lower intercept age and the
\eqn{^{207}}Pb/\eqn{^{206}}Pb intercept (for Tera-Wasserburg),
taking into account error correlations and decay constant
uncertainties.
}
\examples{
data(UPb)
fit <- discordia.age(UPb)
print(paste('lower intercept = ',fit$x[1],'+/-',sqrt(fit$cov[1,1]),'Ma'))
}

