% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-c.R
\name{c}
\alias{c}
\alias{c,IntervalData-method}
\alias{c,IntervalList-method}
\title{Combine interval-valued data into an interval-valued data list}
\usage{
\S4method{c}{IntervalData}(x, ...)
\S4method{c}{IntervalList}(x, ...)
}
\arguments{
\item{x}{an \code{IntervalData} or \code{IntervalList} object.}

\item{...}{additional arguments.}
}
\value{
An interval-valued data list with the combination of given elements
}
\description{
This function combines its arguments into a object of class \code{IntervalList}.
}
\examples{
## Combine 'IntervalData' objects
i1 <- IntervalData(0, 1)
i2 <- IntervalData(0, 2)
list1 <- c(i1, i2)
list1

## Combine 'IntervalList' objects
list2 <- c(list1, list1)
list2

## Combine both 'IntervalData' and 'IntervalList' objects
list3 <- c(i1, list1)
list3
list4 <- c(list1, i1)
list4
}
\author{
Jose Garcia Garcia \email{garciagarjose@uniovi.es}
}
