% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Main.R
\name{plotROC}
\alias{plotROC}
\title{plotROC}
\usage{
plotROC(actuals, predictedScores, Show.labels = F, returnSensitivityMat = F)
}
\arguments{
\item{actuals}{The actual binary flags for the response variable. It can take a numeric vector containing values of either 1 or 0, where 1 represents the 'Good' or 'Events' while 0 represents 'Bad' or 'Non-Events'.}

\item{predictedScores}{The prediction probability scores for each observation. If your classification model gives the 1/0 predcitions, convert it to a numeric vector of 1's and 0's.}

\item{Show.labels}{Whether the probability scores should be printed at change points?. Defaults to False.}

\item{returnSensitivityMat}{Whether the sensitivity matrix (a dataframe) should be returned. Defaults to FALSE.}
}
\value{
Plots the ROC curve
}
\description{
Plot the Receiver Operating Characteristics(ROC) Curve based on ggplot2
}
\details{
For a given actuals and predicted probability scores, A ROC curve is plotted using the ggplot2 framework along the the area under the curve.
}
\examples{
data('ActualsAndScores')
plotROC(actuals=ActualsAndScores$Actuals, predictedScores=ActualsAndScores$PredictedScores)
}
\author{
Selva Prabhakaran \email{selva86@gmail.com}
}

