% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InflectWorkflow.R
\name{InflectWorkflow}
\alias{InflectWorkflow}
\title{This function analyzes raw abundance data from a Thermal Profiling experiment and calculates melt temperatures and melt shifts for each protein in the experiment.
See the Inflect function file for an example of program that could be executed to test the program function.}
\usage{
InflectWorkflow(Rsq, NumSD, Temperature, Rep, SourcePath, OutputPath)
}
\arguments{
\item{Rsq}{the cutoff to be used for the melt shift curve fit. An example entry would be 0.95}

\item{NumSD}{the standard deviation cutoff to be used for the calculated melt shifts. For example, if NumSD = 2, proteins with melt shifts greater than 2 standard deviations from the mean will be considered significant.}

\item{Temperature}{the temperatures from the heat treatment procedure. An example entry Temperature<-c(25,35,39.3,50.1,55.2,60.7,74.9,90)}

\item{Rep}{the replicate number that is being analyzed}

\item{SourcePath}{The path for the source data}

\item{OutputPath}{The path for the output data}
}
\value{
xlsx files with calculated melt shift for each protein in the experiment
}
\description{
This function analyzes raw abundance data from a Thermal Profiling experiment and calculates melt temperatures and melt shifts for each protein in the experiment.
See the Inflect function file for an example of program that could be executed to test the program function.
}
