\name{DepMarkedNHPP.fun}
\alias{DepMarkedNHPP.fun}


\title{Generates trajectories of dependent  point processes using  a marked Poison Process}

\description{ This function  generates \eqn{d} dependent  (homogeneous or nonhomogeneous) point processes 
using a marked PP, where the marks are generated by a Markov chain process defined by a  given transition matrix.  
}

\usage{DepMarkedNHPP.fun(lambdaTot, MarkovM, inival = 1, fixed.seed=NULL)}


\arguments{
  \item{lambdaTot}{Numeric vector. Intensity values  of the  underlying PP used to generate the dependent processes.}

  \item{MarkovM}{Matrix. Trasition probabilities of  the d-state Markov chain used to generate the marks of the PP.}

  \item{inival}{Optional. Initial  mark value used to generate the series of marks.}

  \item{fixed.seed}{Optional. An integer or NULL. Value used to set the seed 
	in random generation processes; if it is NULL, a random seed is used.}
}

\details{


Points  of the marked PP are generated in continuous time, using the  following procedure: 
First, a trajectory of the underlying PP,   which represents the global process of  the occurrences 
in all the processes,  is generated.  Then, the  mark series is generated using a d-state Markov chain. 
The mark series takes values in 1,2,...,d and determines in which of the d processes  the point  occurs

A transition matrix \eqn{P = (p_{ij})} with
 equal rows leads to d independent point processes, and the more similar the rows of P, the less dependent the
resulting processes.  Some dependence measures  between the generated processes,  such as the spectral gap, 
are suggested in Abaurrea et al. (2014).


It is noteworthy, that the processes defined by the marks  are not Poisson, since the generated marks are
dependent observations,  see Isham (1980). 



}


\value{
 A list with elements
  \item{posNH }{Numeric vector of the occurrences times of the underlying PP generated.}
  \item{mark }{Vector of the  generated marks, which indicate the process where the point  occurs.}
  \item{lambdaTot }{Input argument.}
  \item{MarkovM }{Input argument.}
}

\references{
Abaurrea, J. Asin, J. and Cebrian, A.C. (2014). A Bootstrap Test of Independence Between Three Temporal Nonhomogeneous Poisson Processes 
and its Application to Heat Wave Modeling. \emph{Environmental and Ecological Statistics},  22(1), 127-144.

Isham, V. (1980). Dependent thinning of point processes. \emph{J. Appl. Probab.}, 17(4), 987-95.
}



\seealso{\code{\link{DepNHPPqueue.fun}}, \code{\link{DepNHNeyScot.fun}}, \code{\link{DepNHCPSP.fun}}, 
	\code{\link{IndNHPP.fun}}, \code{\link{SpecGap.fun}}  }

\examples{

# Generation of three dependent  point processes using a marked PP
set.seed(123)
lambdaTot<-runif(1000)/10

aux<-DepMarkedNHPP.fun(lambdaTot=lambdaTot,
	MarkovM=cbind(c(0.3,0.1,0.6), c(0.1, 0.6, 0.3), c(0.6, 0.3,0.1)),fixed.seed=123)
print(cbind(aux$posNH, aux$mark))

}
