% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportDRCDataToDotmatics.R
\name{exportDRCDataToDotmatics}
\alias{exportDRCDataToDotmatics}
\title{exportDRCDataToDotmatics}
\usage{
exportDRCDataToDotmatics(idrc_set_list, platemap)
}
\arguments{
\item{idrc_set_list}{IncucyteDRCSetList object}

\item{platemap}{IncucyteDRCPlatemap object from importPlatemap or importPlatemapXML}
}
\value{
list object with samplelist and data elements
}
\description{
Exports data in Dotmatics format for an IncucyteDRCSet or IncucyteDRCSetList object that represents
a full plate of data.
The platemap must be provided as an IncucyteDRCPlatemap object and should correspond to the data
contained in the IncucyteDRCSet or IncucyteDRCSetList object.
}
\examples{
pm_file <- system.file(file='extdata/example.PlateMap', package='IncucyteDRC')
test_pm <- importPlatemapXML(pm_file)
data_file <- system.file(file='extdata/example_data.txt', package='IncucyteDRC')
test_data <- importIncucyteData(data_file, metric='pc')

test_drc <- splitIncucyteDRCPlateData(test_pm, test_data, group_columns='growthcondition')
test_drc <- lapply(test_drc, fitGrowthCurvesIndividual)
test_drc <- lapply(test_drc, fitGrowthCurvesGrouped)
test_drc <- lapply(test_drc, calculateDRCData, cut_time=100)
print(test_drc)
print(test_drc[[2]])
exportDRCDataToDotmatics(test_drc, test_pm)
exportDRCDataToDotmatics(test_drc[[2]], test_pm)
}

