% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmarkIncidencePrevalence.R
\name{benchmarkIncidencePrevalence}
\alias{benchmarkIncidencePrevalence}
\title{Run benchmark of incidence and prevalence analyses}
\usage{
benchmarkIncidencePrevalence(
  cdm,
  startDate = NULL,
  endDate = NULL,
  tablePrefix = NULL,
  returnParticipants = FALSE,
  sample = NULL,
  nOutcomes = 1,
  prevOutcomes = 0.25,
  analysisType = "all",
  outputFolder = NULL,
  fileName = NULL,
  verbose = FALSE
)
}
\arguments{
\item{cdm}{A CDM reference object}

\item{startDate}{A date indicating the start of the study
period to be used for the denominator cohort. If NULL, the earliest
observation_start_date in the observation_period table will be used.}

\item{endDate}{A date indicating the end of the study
period to be used for the denominator cohort. If NULL, the latest
observation end date in the observation period  table will be used.}

\item{tablePrefix}{The stem for the permanent tables that will
be created. Permanent tables will be created using this stem, and any
existing tables that start with this will be at risk of being dropped
or overwritten. If NULL, temporary tables will be used throughout.}

\item{returnParticipants}{Whether to return participants (Requires tablePrefix
to have been specified)}

\item{sample}{An integer for which to take a random sample when generating
the denominator cohort}

\item{nOutcomes}{An integer specifying the number of outcomes to create in
the denominator cohort}

\item{prevOutcomes}{An array of integers for the prevalence of the outcomes
in the population (in \%). If the user wants all the outcomes with the same
prevalence, they can also provide a single integer}

\item{analysisType}{A string of the following: "all", "only incidence",
"only prevalence"}

\item{outputFolder}{Folder to save results as CSV}

\item{fileName}{Name given to CSV with results}

\item{verbose}{Either TRUE or FALSE. If TRUE, progress will be reported.}
}
\value{
a tibble with time taken for different analyses
}
\description{
Run benchmark of incidence and prevalence analyses
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(sampleSize = 10000,
                                  earliestObservationStartDate = as.Date("2010-01-01") ,
                                  latestObservationStartDate = as.Date("2018-01-01"))
timings <- IncidencePrevalence::benchmarkIncidencePrevalence(cdm,
                                                             verbose = TRUE)
}
}
