% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{incidenceAttrition}
\alias{incidenceAttrition}
\title{Attrition associated with an incidence analysis}
\usage{
incidenceAttrition(result)
}
\arguments{
\item{result}{Result for which to get attrition}
}
\value{
tibble with counts and reasons for attrition.
}
\description{
Attrition associated with an incidence analysis
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(sampleSize = 200)
cdm$denominator <- generateDenominatorCohortSet(cdm)
inc <- estimateIncidence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome",
  interval = "overall"
)
incidenceAttrition(inc)
}
}
