% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateIncidence.R
\name{estimateIncidence}
\alias{estimateIncidence}
\title{Collect population incidence estimates}
\usage{
estimateIncidence(
  cdm,
  denominatorTable,
  outcomeTable,
  denominatorCohortId = NULL,
  outcomeCohortId = NULL,
  interval = "years",
  completeDatabaseIntervals = TRUE,
  outcomeWashout = Inf,
  repeatedEvents = FALSE,
  minCellCount = 5,
  tablePrefix = NULL,
  returnParticipants = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{cdm}{A CDM reference object}

\item{denominatorTable}{A cohort table with a set of denominator cohorts
(for example, created using the \code{generateDenominatorCohortSet()}
function).}

\item{outcomeTable}{A cohort table in the cdm reference containing
a set of outcome cohorts.}

\item{denominatorCohortId}{The cohort definition ids of the denominator
cohorts of interest. If NULL all cohorts will be considered in the
analysis.}

\item{outcomeCohortId}{The cohort definition ids of the outcome
cohorts of interest. If NULL all cohorts will be considered in the
analysis.}

\item{interval}{Time intervals over which incidence is estimated. Can
be "weeks", "months", "quarters", "years", or "overall". ISO weeks will
be used for weeks. Calendar months, quarters, or years can be used, or an
overall estimate for the entire time period observed (from earliest cohort
start to last cohort end) can also be estimated. If more than one option is
chosen then results will be estimated for each chosen interval.}

\item{completeDatabaseIntervals}{TRUE/ FALSE. Where TRUE, incidence will
only be estimated for those intervals where the database
captures all the interval (based on the earliest and latest observation
period start dates, respectively).}

\item{outcomeWashout}{The number of days used for a 'washout' period
between the end of one outcome and an individual starting to contribute
time at risk. If Inf, no time can be contributed after an event has
occurred (whether during the study period or if occurring beforehand).}

\item{repeatedEvents}{TRUE/ FALSE. If TRUE, an individual will be able to
contribute multiple events during the study period (time while they are
present in an outcome cohort and any subsequent washout will be
excluded). If FALSE, an individual will only contribute time up to their
first event during the study period.}

\item{minCellCount}{The minimum number of events to reported, below which
results will be obscured. If 0, all results will be reported.}

\item{tablePrefix}{The stem for the permanent tables that will
be created when running the analysis. Permanent tables will be created using
this prefix, and any existing tables that start with this will be at risk of
being dropped or overwritten. If NULL, temporary tables will be
used throughout.}

\item{returnParticipants}{Either TRUE or FALSE. If TRUE references to
participants from the analysis will be returned allowing for further
analysis. Note, if using permanent tables and returnParticipants is TRUE,
one table per analysis will be kept in the cdm write schema.}

\item{verbose}{Either TRUE or FALSE. If TRUE, progress will be reported.}
}
\value{
Incidence estimates
}
\description{
Collect population incidence estimates
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(sampleSize = 10000)
cdm$denominator <- generateDenominatorCohortSet(
  cdm = cdm,
  startDate = as.Date("2008-01-01"),
  endDate = as.Date("2018-01-01")
)
inc <- estimateIncidence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome"
)
}
}
