/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tshort;

import cern.colt.PersistentObject;
import cern.colt.buffer.tshort.ShortBuffer3DConsumer;
import cern.colt.list.tshort.ShortArrayList;

public class ShortBuffer3D
extends PersistentObject
implements ShortBuffer3DConsumer {
    private static final long serialVersionUID = 1L;
    protected ShortBuffer3DConsumer target;
    protected short[] xElements;
    protected short[] yElements;
    protected short[] zElements;
    protected ShortArrayList xList;
    protected ShortArrayList yList;
    protected ShortArrayList zList;
    protected int capacity;
    protected int size;

    public ShortBuffer3D(ShortBuffer3DConsumer shortBuffer3DConsumer, int n) {
        this.target = shortBuffer3DConsumer;
        this.capacity = n;
        this.xElements = new short[n];
        this.yElements = new short[n];
        this.zElements = new short[n];
        this.xList = new ShortArrayList(this.xElements);
        this.yList = new ShortArrayList(this.yElements);
        this.zList = new ShortArrayList(this.zElements);
        this.size = 0;
    }

    public void add(short s, short s2, short s3) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = s;
        this.yElements[this.size] = s2;
        this.zElements[this.size++] = s3;
    }

    public void addAllOf(ShortArrayList shortArrayList, ShortArrayList shortArrayList2, ShortArrayList shortArrayList3) {
        int n = shortArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(shortArrayList, shortArrayList2, shortArrayList3);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.zList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList, this.zList);
            this.size = 0;
        }
    }
}

