/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tfloat;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.LongFloatProcedure;
import cern.colt.function.tint.IntComparator;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.map.AbstractMap;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public abstract class AbstractLongFloatMap
extends AbstractMap {
    private static final long serialVersionUID = 1L;

    protected AbstractLongFloatMap() {
    }

    public void assign(final FloatFunction floatFunction) {
        this.copy().forEachPair(new LongFloatProcedure(){

            public boolean apply(long l, float f) {
                AbstractLongFloatMap.this.put(l, floatFunction.apply(f));
                return true;
            }
        });
    }

    public void assign(AbstractLongFloatMap abstractLongFloatMap) {
        this.clear();
        abstractLongFloatMap.forEachPair(new LongFloatProcedure(){

            public boolean apply(long l, float f) {
                AbstractLongFloatMap.this.put(l, f);
                return true;
            }
        });
    }

    public boolean containsKey(final long l) {
        return !this.forEachKey(new LongProcedure(){

            public boolean apply(long l2) {
                return l != l2;
            }
        });
    }

    public boolean containsValue(final float f) {
        return !this.forEachPair(new LongFloatProcedure(){

            public boolean apply(long l, float f2) {
                return f != f2;
            }
        });
    }

    public AbstractLongFloatMap copy() {
        return (AbstractLongFloatMap)this.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractLongFloatMap)) {
            return false;
        }
        final AbstractLongFloatMap abstractLongFloatMap = (AbstractLongFloatMap)object;
        if (abstractLongFloatMap.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new LongFloatProcedure(){

            public boolean apply(long l, float f) {
                return abstractLongFloatMap.containsKey(l) && abstractLongFloatMap.get(l) == f;
            }
        }) && abstractLongFloatMap.forEachPair(new LongFloatProcedure(){

            public boolean apply(long l, float f) {
                return AbstractLongFloatMap.this.containsKey(l) && AbstractLongFloatMap.this.get(l) == f;
            }
        });
    }

    public abstract boolean forEachKey(LongProcedure var1);

    public boolean forEachPair(final LongFloatProcedure longFloatProcedure) {
        return this.forEachKey(new LongProcedure(){

            public boolean apply(long l) {
                return longFloatProcedure.apply(l, AbstractLongFloatMap.this.get(l));
            }
        });
    }

    public abstract float get(long var1);

    public long keyOf(final float f) {
        final long[] lArray = new long[1];
        boolean bl = this.forEachPair(new LongFloatProcedure(){

            public boolean apply(long l, float f2) {
                boolean bl;
                boolean bl2 = bl = f == f2;
                if (bl) {
                    lArray[0] = l;
                }
                return !bl;
            }
        });
        if (bl) {
            return Long.MIN_VALUE;
        }
        return lArray[0];
    }

    public LongArrayList keys() {
        LongArrayList longArrayList = new LongArrayList(this.size());
        this.keys(longArrayList);
        return longArrayList;
    }

    public void keys(final LongArrayList longArrayList) {
        longArrayList.clear();
        this.forEachKey(new LongProcedure(){

            public boolean apply(long l) {
                longArrayList.add(l);
                return true;
            }
        });
    }

    public void keysSortedByValue(LongArrayList longArrayList) {
        this.pairsSortedByValue(longArrayList, new FloatArrayList(this.size()));
    }

    public void pairsMatching(final LongFloatProcedure longFloatProcedure, final LongArrayList longArrayList, final FloatArrayList floatArrayList) {
        longArrayList.clear();
        floatArrayList.clear();
        this.forEachPair(new LongFloatProcedure(){

            public boolean apply(long l, float f) {
                if (longFloatProcedure.apply(l, f)) {
                    longArrayList.add(l);
                    floatArrayList.add(f);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(LongArrayList longArrayList, FloatArrayList floatArrayList) {
        this.keys(longArrayList);
        longArrayList.sort();
        int n = longArrayList.size();
        floatArrayList.setSize(n);
        final float[] fArray = floatArrayList.elements();
        final long[] lArray = longArrayList.elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = n - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4;
                        while (--n >= n5) {
                            fArray[n] = AbstractLongFloatMap.this.get(lArray[n]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = longArrayList.size();
            while (--n6 >= 0) {
                fArray[n6] = this.get(lArray[n6]);
            }
        }
    }

    public void pairsSortedByValue(LongArrayList longArrayList, FloatArrayList floatArrayList) {
        this.keys(longArrayList);
        this.values(floatArrayList);
        final long[] lArray = longArrayList.elements();
        final float[] fArray = floatArrayList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                float f = fArray[n];
                fArray[n] = fArray[n2];
                fArray[n2] = f;
                long l = lArray[n];
                lArray[n] = lArray[n2];
                lArray[n2] = l;
            }
        };
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return fArray[n] < fArray[n2] ? -1 : (fArray[n] > fArray[n2] ? 1 : (lArray[n] < lArray[n2] ? -1 : (lArray[n] == lArray[n2] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, longArrayList.size(), intComparator, swapper);
    }

    public abstract boolean put(long var1, float var3);

    public abstract boolean removeKey(long var1);

    public String toString() {
        LongArrayList longArrayList = this.keys();
        String string = longArrayList.toString() + "\n";
        longArrayList.sort();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("[");
        int n = longArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            long l = longArrayList.get(i);
            stringBuffer.append(String.valueOf(l));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(l)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toStringByValue() {
        LongArrayList longArrayList = new LongArrayList();
        this.keysSortedByValue(longArrayList);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = longArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            long l = longArrayList.get(i);
            stringBuffer.append(String.valueOf(l));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(l)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public FloatArrayList values() {
        FloatArrayList floatArrayList = new FloatArrayList(this.size());
        this.values(floatArrayList);
        return floatArrayList;
    }

    public void values(final FloatArrayList floatArrayList) {
        floatArrayList.clear();
        this.forEachKey(new LongProcedure(){

            public boolean apply(long l) {
                floatArrayList.add(AbstractLongFloatMap.this.get(l));
                return true;
            }
        });
    }
}

