/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.map.tlong.AbstractLongLongMap;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix2D;

class SelectedSparseLongMatrix1D
extends LongMatrix1D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongLongMap elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedSparseLongMatrix1D(AbstractLongLongMap abstractLongLongMap, int[] nArray) {
        this(nArray.length, abstractLongLongMap, 0, 1, nArray, 0);
    }

    protected SelectedSparseLongMatrix1D(int n, AbstractLongLongMap abstractLongLongMap, int n2, int n3, int[] nArray, int n4) {
        this.setUp(n, n2, n3);
        this.elements = abstractLongLongMap;
        this.offsets = nArray;
        this.offset = n4;
        this.isNoView = false;
    }

    public AbstractLongLongMap elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public long getQuick(int n) {
        return this.elements.get((long)this.offset + (long)this.offsets[this.zero + n * this.stride]);
    }

    public long index(int n) {
        return (long)this.offset + (long)this.offsets[this.zero + n * this.stride];
    }

    public LongMatrix1D like(int n) {
        return new SparseLongMatrix1D(n);
    }

    public LongMatrix2D like2D(int n, int n2) {
        return new SparseLongMatrix2D(n, n2);
    }

    public LongMatrix2D reshape(int n, int n2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public LongMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public void setQuick(int n, long l) {
        long l2 = (long)this.offset + (long)this.offsets[this.zero + n * this.stride];
        if (l == 0L) {
            this.elements.removeKey(l2);
        } else {
            this.elements.put(l2, l);
        }
    }

    protected int _offset(int n) {
        return this.offsets[n];
    }

    protected boolean haveSharedCellsRaw(LongMatrix1D longMatrix1D) {
        if (longMatrix1D instanceof SelectedSparseLongMatrix1D) {
            SelectedSparseLongMatrix1D selectedSparseLongMatrix1D = (SelectedSparseLongMatrix1D)longMatrix1D;
            return this.elements == selectedSparseLongMatrix1D.elements;
        }
        if (longMatrix1D instanceof SparseLongMatrix1D) {
            SparseLongMatrix1D sparseLongMatrix1D = (SparseLongMatrix1D)longMatrix1D;
            return this.elements == sparseLongMatrix1D.elements;
        }
        return false;
    }

    protected void setUp(int n) {
        super.setUp(n);
        this.stride = 1;
        this.offset = 0;
    }

    protected LongMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseLongMatrix1D(this.elements, nArray);
    }
}

