/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.IntIntFComplexFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseCCFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.WrapperFComplexMatrix2D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.math.tfcomplex.FComplexMult;
import cern.jet.math.tfcomplex.FComplexPlusMultFirst;
import cern.jet.math.tfcomplex.FComplexPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseRCFComplexMatrix2D
extends WrapperFComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] rowPointers;
    protected int[] columnIndexes;
    protected float[] values;

    private static int searchFromTo(int[] nArray, int n, int n2, int n3) {
        while (n2 <= n3) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -(n2 + 1);
    }

    public SparseRCFComplexMatrix2D(float[][] fArray) {
        this(fArray.length, fArray.length == 0 ? 0 : fArray[0].length);
        this.assign(fArray);
    }

    public SparseRCFComplexMatrix2D(int n, int n2) {
        this(n, n2, (int)Math.min(10L * (long)n, Integer.MAX_VALUE));
    }

    public SparseRCFComplexMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.columnIndexes = new int[n3];
        this.values = new float[2 * n3];
        this.rowPointers = new int[n + 1];
    }

    public SparseRCFComplexMatrix2D(int n, int n2, int[] nArray, int[] nArray2, float f, float f2, boolean bl) {
        int n3;
        block7: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block7;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (f == 0.0f && f2 == 0.0f) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int n4 = Math.max(nArray.length, 1);
        this.columnIndexes = new int[n4];
        this.values = new float[2 * n4];
        this.rowPointers = new int[n + 1];
        int[] nArray3 = new int[n];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.rowPointers, nArray3, n);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.columnIndexes[var10_12] = nArray2[n3];
            this.values[2 * var10_12] = f;
            this.values[2 * var10_12 + 1] = f2;
        }
        if (bl) {
            this.removeDuplicates();
        }
    }

    public SparseRCFComplexMatrix2D(int n, int n2, int[] nArray, int[] nArray2, float[] fArray, boolean bl, boolean bl2) {
        int n3;
        block8: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block8;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (2 * nArray.length != fArray.length) {
            throw new IllegalArgumentException("2 * rowIndexes.length != values.length");
        }
        int n4 = Math.max(nArray.length, 1);
        this.columnIndexes = new int[n4];
        this.values = new float[2 * n4];
        this.rowPointers = new int[n + 1];
        int[] nArray3 = new int[n];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.rowPointers, nArray3, n);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.columnIndexes[var10_12] = nArray2[n3];
            this.values[2 * var10_12] = fArray[2 * n3];
            this.values[2 * var10_12 + 1] = fArray[2 * n3 + 1];
        }
        if (bl2) {
            this.removeZeroes();
        }
        if (bl) {
            this.removeDuplicates();
        }
    }

    public SparseRCFComplexMatrix2D(int n, int n2, int[] nArray, int[] nArray2, float[] fArray) {
        block4: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block4;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != n + 1) {
            throw new IllegalArgumentException("rowPointers.length != rows + 1");
        }
        if (2 * nArray2.length != fArray.length) {
            throw new IllegalArgumentException("2 * columnIndexes.length != values.length");
        }
        this.rowPointers = nArray;
        this.columnIndexes = nArray2;
        this.values = fArray;
    }

    public FComplexMatrix2D assign(final FComplexFComplexFunction fComplexFComplexFunction) {
        if (fComplexFComplexFunction instanceof FComplexMult) {
            float[] fArray = ((FComplexMult)fComplexFComplexFunction).multiplicator;
            if (fArray[0] == 1.0f && fArray[1] == 0.0f) {
                return this;
            }
            if (fArray[0] == 0.0f && fArray[1] == 0.0f) {
                return this.assign(fArray);
            }
            if (fArray[0] != fArray[0] || fArray[1] != fArray[1]) {
                return this.assign(fArray);
            }
            int n = this.cardinality();
            float[] fArray2 = new float[2];
            for (int i = 0; i < n; ++i) {
                fArray2[0] = this.values[2 * i];
                fArray2[1] = this.values[2 * i + 1];
                fArray2 = FComplex.mult(fArray2, fArray);
                this.values[2 * i] = fArray2[0];
                this.values[2 * i + 1] = fArray2[1];
            }
        } else {
            this.forEachNonZero(new IntIntFComplexFunction(){

                public float[] apply(int n, int n2, float[] fArray) {
                    return fComplexFComplexFunction.apply(fArray);
                }
            });
        }
        return this;
    }

    public FComplexMatrix2D assign(float f, float f2) {
        if (f == 0.0f && f2 == 0.0f) {
            Arrays.fill(this.rowPointers, 0);
            Arrays.fill(this.columnIndexes, 0);
            Arrays.fill(this.values, 0.0f);
        } else {
            int n = this.cardinality();
            for (int i = 0; i < n; ++i) {
                this.values[2 * i] = f;
                this.values[2 * i + 1] = f2;
            }
        }
        return this;
    }

    public FComplexMatrix2D assign(FComplexMatrix2D fComplexMatrix2D) {
        if (fComplexMatrix2D == this) {
            return this;
        }
        this.checkShape(fComplexMatrix2D);
        if (fComplexMatrix2D instanceof SparseRCFComplexMatrix2D) {
            SparseRCFComplexMatrix2D sparseRCFComplexMatrix2D = (SparseRCFComplexMatrix2D)fComplexMatrix2D;
            System.arraycopy(sparseRCFComplexMatrix2D.rowPointers, 0, this.rowPointers, 0, this.rows + 1);
            int n = sparseRCFComplexMatrix2D.columnIndexes.length;
            if (this.columnIndexes.length < n) {
                this.columnIndexes = new int[n];
                this.values = new float[2 * n];
            }
            System.arraycopy(sparseRCFComplexMatrix2D.columnIndexes, 0, this.columnIndexes, 0, n);
            System.arraycopy(sparseRCFComplexMatrix2D.values, 0, this.values, 0, sparseRCFComplexMatrix2D.values.length);
        } else if (fComplexMatrix2D instanceof SparseCCFComplexMatrix2D) {
            SparseCCFComplexMatrix2D sparseCCFComplexMatrix2D = ((SparseCCFComplexMatrix2D)fComplexMatrix2D).getConjugateTranspose();
            this.rowPointers = sparseCCFComplexMatrix2D.getColumnPointers();
            this.columnIndexes = sparseCCFComplexMatrix2D.getRowIndexes();
            this.values = sparseCCFComplexMatrix2D.getValues();
        } else {
            this.assign(0.0f, 0.0f);
            fComplexMatrix2D.forEachNonZero(new IntIntFComplexFunction(){

                public float[] apply(int n, int n2, float[] fArray) {
                    SparseRCFComplexMatrix2D.this.setQuick(n, n2, fArray);
                    return fArray;
                }
            });
        }
        return this;
    }

    public FComplexMatrix2D assign(FComplexMatrix2D fComplexMatrix2D, FComplexFComplexFComplexFunction fComplexFComplexFComplexFunction) {
        Object object;
        this.checkShape(fComplexMatrix2D);
        if (fComplexMatrix2D instanceof SparseRCFComplexMatrix2D && fComplexFComplexFComplexFunction == FComplexFunctions.plus) {
            object = (SparseRCFComplexMatrix2D)fComplexMatrix2D;
            int[] nArray = ((SparseRCFComplexMatrix2D)object).rowPointers;
            int[] nArray2 = ((SparseRCFComplexMatrix2D)object).columnIndexes;
            float[] fArray = ((SparseRCFComplexMatrix2D)object).values;
            int[] nArray3 = new int[this.rows + 1];
            int n = Math.max(this.columnIndexes.length, (int)Math.min(Integer.MAX_VALUE, (long)this.rowPointers[this.rows] + (long)nArray[this.rows]));
            int[] nArray4 = new int[n];
            float[] fArray2 = new float[2 * n];
            int n2 = this.rows;
            int n3 = this.columns;
            int n4 = n;
            if (fComplexFComplexFComplexFunction == FComplexFunctions.plus) {
                int n5;
                nArray3[0] = n5 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n6 = this.rowPointers[i];
                    int n7 = nArray[i];
                    int n8 = this.rowPointers[i + 1] - 1;
                    int n9 = nArray[i + 1] - 1;
                    while (n6 <= n8 || n7 <= n9) {
                        int n10;
                        int n11 = n6 <= n8 ? this.columnIndexes[n6] : n3 + 1;
                        if (n11 == (n10 = n7 <= n9 ? nArray2[n7] : n3 + 1)) {
                            fArray2[2 * n5] = this.values[2 * n6] + fArray[2 * n7];
                            fArray2[2 * n5 + 1] = this.values[2 * n6 + 1] + fArray[2 * n7 + 1];
                            nArray4[n5] = n11;
                            ++n6;
                            ++n7;
                            ++n5;
                        } else if (n11 < n10) {
                            nArray4[n5] = n11;
                            fArray2[2 * n5] = this.values[2 * n6];
                            fArray2[2 * n5 + 1] = this.values[2 * n6 + 1];
                            ++n6;
                            ++n5;
                        } else if (n11 > n10) {
                            nArray4[n5] = n10;
                            fArray2[2 * n5] = fArray[2 * n7];
                            fArray2[2 * n5 + 1] = fArray[2 * n7 + 1];
                            ++n7;
                            ++n5;
                        }
                        if (n5 < n4) continue;
                        throw new IllegalArgumentException("The number of elements in C exceeds nzmax");
                    }
                    nArray3[i + 1] = n5;
                }
                this.rowPointers = nArray3;
                this.columnIndexes = nArray4;
                this.values = fArray2;
                return this;
            }
        }
        if (fComplexFComplexFComplexFunction instanceof FComplexPlusMultSecond) {
            object = ((FComplexPlusMultSecond)fComplexFComplexFComplexFunction).multiplicator;
            if (object[0] == 0.0f && object[1] == 0.0f) {
                return this;
            }
            fComplexMatrix2D.forEachNonZero(new IntIntFComplexFunction((float[])object){
                final /* synthetic */ float[] val$alpha;
                {
                    this.val$alpha = fArray;
                }

                public float[] apply(int n, int n2, float[] fArray) {
                    SparseRCFComplexMatrix2D.this.setQuick(n, n2, FComplex.plus(SparseRCFComplexMatrix2D.this.getQuick(n, n2), FComplex.mult(this.val$alpha, fArray)));
                    return fArray;
                }
            });
            return this;
        }
        if (fComplexFComplexFComplexFunction instanceof FComplexPlusMultFirst) {
            object = ((FComplexPlusMultFirst)fComplexFComplexFComplexFunction).multiplicator;
            if (object[0] == 0.0f && object[1] == 0.0f) {
                return this.assign(fComplexMatrix2D);
            }
            fComplexMatrix2D.forEachNonZero(new IntIntFComplexFunction((float[])object){
                final /* synthetic */ float[] val$alpha;
                {
                    this.val$alpha = fArray;
                }

                public float[] apply(int n, int n2, float[] fArray) {
                    SparseRCFComplexMatrix2D.this.setQuick(n, n2, FComplex.plus(FComplex.mult(this.val$alpha, SparseRCFComplexMatrix2D.this.getQuick(n, n2)), fArray));
                    return fArray;
                }
            });
            return this;
        }
        if (fComplexFComplexFComplexFunction == FComplexFunctions.mult) {
            object = new float[2];
            for (int i = 0; i < this.rows; ++i) {
                int n = this.rowPointers[i + 1];
                for (int j = this.rowPointers[i]; j < n; ++j) {
                    int n12 = this.columnIndexes[j];
                    object[0] = this.values[2 * j];
                    object[1] = this.values[2 * j + 1];
                    object = FComplex.mult((float[])object, fComplexMatrix2D.getQuick(i, n12));
                    this.values[2 * j] = (float)object[0];
                    this.values[2 * j + 1] = (float)object[1];
                    if (this.values[2 * j] != 0.0f || this.values[2 * j + 1] != 0.0f) continue;
                    this.remove(i, n12);
                }
            }
            return this;
        }
        if (fComplexFComplexFComplexFunction == FComplexFunctions.div) {
            object = new float[2];
            for (int i = 0; i < this.rows; ++i) {
                int n = this.rowPointers[i + 1];
                for (int j = this.rowPointers[i]; j < n; ++j) {
                    int n13 = this.columnIndexes[j];
                    object[0] = this.values[2 * j];
                    object[1] = this.values[2 * j + 1];
                    object = FComplex.div((float[])object, fComplexMatrix2D.getQuick(i, n13));
                    this.values[2 * j] = (float)object[0];
                    this.values[2 * j + 1] = (float)object[1];
                    if (this.values[2 * j] != 0.0f || this.values[2 * j + 1] != 0.0f) continue;
                    this.remove(i, n13);
                }
            }
            return this;
        }
        return super.assign(fComplexMatrix2D, fComplexFComplexFComplexFunction);
    }

    public int cardinality() {
        return this.rowPointers[this.rows];
    }

    public FComplexMatrix2D forEachNonZero(IntIntFComplexFunction intIntFComplexFunction) {
        float[] fArray = new float[2];
        for (int i = 0; i < this.rows; ++i) {
            int n = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < n; ++j) {
                int n2 = this.columnIndexes[j];
                fArray[0] = this.values[2 * j];
                fArray[1] = this.values[2 * j + 1];
                float[] fArray2 = intIntFComplexFunction.apply(i, n2, fArray);
                if (fArray2[0] == fArray[0] && fArray2[1] == fArray[1]) continue;
                this.values[2 * j] = fArray2[0];
                this.values[2 * j + 1] = fArray2[1];
            }
        }
        return this;
    }

    public SparseCCFComplexMatrix2D getColumnCompressed() {
        SparseRCFComplexMatrix2D sparseRCFComplexMatrix2D = this.getConjugateTranspose();
        SparseCCFComplexMatrix2D sparseCCFComplexMatrix2D = new SparseCCFComplexMatrix2D(this.rows, this.columns);
        sparseCCFComplexMatrix2D.rowIndexes = sparseRCFComplexMatrix2D.columnIndexes;
        sparseCCFComplexMatrix2D.columnPointers = sparseRCFComplexMatrix2D.rowPointers;
        sparseCCFComplexMatrix2D.values = sparseRCFComplexMatrix2D.values;
        return sparseCCFComplexMatrix2D;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public DenseFComplexMatrix2D getDense() {
        final DenseFComplexMatrix2D denseFComplexMatrix2D = new DenseFComplexMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntFComplexFunction(){

            public float[] apply(int n, int n2, float[] fArray) {
                denseFComplexMatrix2D.setQuick(n, n2, SparseRCFComplexMatrix2D.this.getQuick(n, n2));
                return fArray;
            }
        });
        return denseFComplexMatrix2D;
    }

    public synchronized float[] getQuick(int n, int n2) {
        int n3 = SparseRCFComplexMatrix2D.searchFromTo(this.columnIndexes, n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        float[] fArray = new float[2];
        if (n3 >= 0) {
            fArray[0] = this.values[2 * n3];
            fArray[1] = this.values[2 * n3 + 1];
        }
        return fArray;
    }

    public int[] getRowPointers() {
        return this.rowPointers;
    }

    public SparseRCFComplexMatrix2D getConjugateTranspose() {
        int n = this.rowPointers[this.rows];
        int[] nArray = new int[this.columns];
        int[] nArray2 = new int[this.columns + 1];
        int[] nArray3 = new int[n];
        float[] fArray = new float[2 * n];
        for (int i = 0; i < n; ++i) {
            int n2 = this.columnIndexes[i];
            nArray[n2] = nArray[n2] + 1;
        }
        this.cumsum(nArray2, nArray, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            int n3 = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < n3; ++j) {
                int n4 = this.columnIndexes[j];
                nArray[n4] = nArray[n4] + 1;
                nArray3[i] = i;
                fArray[2 * i] = this.values[2 * j];
                fArray[2 * i + 1] = -this.values[2 * j + 1];
            }
        }
        SparseRCFComplexMatrix2D sparseRCFComplexMatrix2D = new SparseRCFComplexMatrix2D(this.columns, this.rows);
        sparseRCFComplexMatrix2D.rowPointers = nArray2;
        sparseRCFComplexMatrix2D.columnIndexes = nArray3;
        sparseRCFComplexMatrix2D.values = fArray;
        return sparseRCFComplexMatrix2D;
    }

    public float[] getValues() {
        return this.values;
    }

    public FComplexMatrix2D like(int n, int n2) {
        return new SparseRCFComplexMatrix2D(n, n2);
    }

    public FComplexMatrix1D like1D(int n) {
        return new SparseFComplexMatrix1D(n);
    }

    public void removeDuplicates() {
        int n;
        int n2 = 0;
        int[] nArray = new int[this.columns];
        for (n = 0; n < this.columns; ++n) {
            nArray[n] = -1;
        }
        for (int i = 0; i < this.rows; ++i) {
            int n3 = n2;
            for (int j = this.rowPointers[i]; j < this.rowPointers[i + 1]; ++j) {
                n = this.columnIndexes[j];
                if (nArray[n] >= n3) {
                    int n4 = 2 * nArray[n];
                    this.values[n4] = this.values[n4] + this.values[2 * j];
                    int n5 = 2 * nArray[n] + 1;
                    this.values[n5] = this.values[n5] + this.values[2 * j + 1];
                    continue;
                }
                nArray[n] = n2;
                this.columnIndexes[n2] = n;
                this.values[2 * n2] = this.values[2 * j];
                this.values[2 * n2 + 1] = this.values[2 * j + 1];
                ++n2;
            }
            this.rowPointers[i] = n3;
        }
        this.rowPointers[this.rows] = n2;
    }

    public void removeZeroes() {
        int n = 0;
        float f = (float)Math.pow(2.0, -23.0);
        float[] fArray = new float[2];
        for (int i = 0; i < this.rows; ++i) {
            this.rowPointers[i] = n;
            for (int j = this.rowPointers[i]; j < this.rowPointers[i + 1]; ++j) {
                fArray[0] = this.values[2 * j];
                fArray[1] = this.values[2 * j + 1];
                if (!(FComplex.abs(fArray) > f)) continue;
                this.values[2 * n] = this.values[2 * j];
                this.values[2 * n + 1] = this.values[2 * j + 1];
                this.columnIndexes[n++] = this.columnIndexes[j];
            }
        }
        this.rowPointers[this.rows] = n;
    }

    public synchronized void setQuick(int n, int n2, float[] fArray) {
        int n3 = SparseRCFComplexMatrix2D.searchFromTo(this.columnIndexes, n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        if (n3 >= 0) {
            if (fArray[0] == 0.0f && fArray[1] == 0.0f) {
                this.remove(n, n3);
            } else {
                this.values[2 * n3] = fArray[0];
                this.values[2 * n3 + 1] = fArray[1];
            }
            return;
        }
        if (fArray[0] != 0.0f || fArray[1] != 0.0f) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, fArray);
        }
    }

    public synchronized void setQuick(int n, int n2, float f, float f2) {
        int n3 = SparseRCFComplexMatrix2D.searchFromTo(this.columnIndexes, n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        if (n3 >= 0) {
            if (f == 0.0f && f2 == 0.0f) {
                this.remove(n, n3);
            } else {
                this.values[2 * n3] = f;
                this.values[2 * n3 + 1] = f2;
            }
            return;
        }
        if (f != 0.0f || f2 != 0.0f) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, f, f2);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.rows; ++i) {
            int n = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < n; ++j) {
                if (this.values[2 * j + 1] > 0.0f) {
                    stringBuilder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[2 * j]).append('+').append(this.values[2 * j + 1]).append('i').append('\n');
                    continue;
                }
                if (this.values[2 * j + 1] == 0.0f) {
                    stringBuilder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[2 * j]).append('\n');
                    continue;
                }
                stringBuilder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[2 * j]).append('-').append(this.values[2 * j + 1]).append('i').append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public void trimToSize() {
        this.realloc(0);
    }

    public FComplexMatrix1D zMult(FComplexMatrix1D fComplexMatrix1D, FComplexMatrix1D fComplexMatrix1D2, final float[] fArray, final float[] fArray2, boolean bl) {
        boolean bl2;
        int n = bl ? this.columns : this.rows;
        int n2 = bl ? this.rows : this.columns;
        boolean bl3 = bl2 = fComplexMatrix1D2 == null || !bl;
        if (fComplexMatrix1D2 == null) {
            fComplexMatrix1D2 = new DenseFComplexMatrix1D(n);
        }
        if (!(fComplexMatrix1D instanceof DenseFComplexMatrix1D) || !(fComplexMatrix1D2 instanceof DenseFComplexMatrix1D)) {
            return super.zMult(fComplexMatrix1D, fComplexMatrix1D2, fArray, fArray2, bl);
        }
        if ((long)n2 != fComplexMatrix1D.size() || (long)n > fComplexMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + fComplexMatrix1D.toStringShort() + ", " + fComplexMatrix1D2.toStringShort());
        }
        DenseFComplexMatrix1D denseFComplexMatrix1D = (DenseFComplexMatrix1D)fComplexMatrix1D2;
        final float[] fArray3 = denseFComplexMatrix1D.elements;
        final int n3 = denseFComplexMatrix1D.stride();
        final int n4 = (int)fComplexMatrix1D2.index(0);
        DenseFComplexMatrix1D denseFComplexMatrix1D2 = (DenseFComplexMatrix1D)fComplexMatrix1D;
        final float[] fArray4 = denseFComplexMatrix1D2.elements;
        final int n5 = denseFComplexMatrix1D2.stride();
        final int n6 = (int)fComplexMatrix1D.index(0);
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (bl) {
            if (!(bl2 || fArray2[0] == 1.0f && fArray2[1] == 0.0f)) {
                fComplexMatrix1D2.assign(FComplexFunctions.mult(fArray2));
            }
            if (n7 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n8;
                n7 = 2;
                Future[] futureArray = new Future[n7];
                final float[] fArray5 = new float[2 * n];
                int n9 = this.rows / n7;
                for (n8 = 0; n8 < n7; ++n8) {
                    final int n10 = n8 * n9;
                    final int n11 = n8 == n7 - 1 ? this.rows : n10 + n9;
                    final int n12 = n8;
                    futureArray[n8] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            float[] fArray6 = new float[2];
                            float[] fArray2 = new float[2];
                            if (n12 == 0) {
                                for (int i = n10; i < n11; ++i) {
                                    int n = SparseRCFComplexMatrix2D.this.rowPointers[i + 1];
                                    fArray6[0] = fArray4[n6 + n5 * i];
                                    fArray6[1] = fArray4[n6 + n5 * i + 1];
                                    fArray6 = FComplex.mult(fArray, fArray6);
                                    for (int j = SparseRCFComplexMatrix2D.this.rowPointers[i]; j < n; ++j) {
                                        int n2 = SparseRCFComplexMatrix2D.this.columnIndexes[j];
                                        fArray2[0] = SparseRCFComplexMatrix2D.this.values[2 * j];
                                        fArray2[1] = -SparseRCFComplexMatrix2D.this.values[2 * j + 1];
                                        fArray2 = FComplex.mult(fArray2, fArray6);
                                        int n32 = n4 + n3 * n2;
                                        fArray3[n32] = fArray3[n32] + fArray2[0];
                                        int n42 = n4 + n3 * n2 + 1;
                                        fArray3[n42] = fArray3[n42] + fArray2[1];
                                    }
                                }
                            } else {
                                for (int i = n10; i < n11; ++i) {
                                    int n = SparseRCFComplexMatrix2D.this.rowPointers[i + 1];
                                    fArray6[0] = fArray4[n6 + n5 * i];
                                    fArray6[1] = fArray4[n6 + n5 * i + 1];
                                    fArray6 = FComplex.mult(fArray, fArray6);
                                    for (int j = SparseRCFComplexMatrix2D.this.rowPointers[i]; j < n; ++j) {
                                        int n52 = SparseRCFComplexMatrix2D.this.columnIndexes[j];
                                        fArray2[0] = SparseRCFComplexMatrix2D.this.values[2 * j];
                                        fArray2[1] = -SparseRCFComplexMatrix2D.this.values[2 * j + 1];
                                        fArray2 = FComplex.mult(fArray2, fArray6);
                                        int n62 = 2 * n52;
                                        fArray5[n62] = fArray5[n62] + fArray2[0];
                                        int n7 = 2 * n52 + 1;
                                        fArray5[n7] = fArray5[n7] + fArray2[1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n8 = 0; n8 < n; ++n8) {
                    int n13 = n4 + n8 * n3;
                    fArray3[n13] = fArray3[n13] + fArray5[2 * n8];
                    int n14 = n4 + n8 * n3 + 1;
                    fArray3[n14] = fArray3[n14] + fArray5[2 * n8 + 1];
                }
            } else {
                float[] fArray6 = new float[2];
                float[] fArray7 = new float[2];
                for (int i = 0; i < this.rows; ++i) {
                    int n15 = this.rowPointers[i + 1];
                    fArray6[0] = fArray4[n6 + n5 * i];
                    fArray6[1] = fArray4[n6 + n5 * i + 1];
                    fArray6 = FComplex.mult(fArray, fArray6);
                    for (int j = this.rowPointers[i]; j < n15; ++j) {
                        int n16 = this.columnIndexes[j];
                        fArray7[0] = this.values[2 * j];
                        fArray7[1] = -this.values[2 * j + 1];
                        fArray7 = FComplex.mult(fArray7, fArray6);
                        int n17 = n4 + n3 * n16;
                        fArray3[n17] = fArray3[n17] + fArray7[0];
                        int n18 = n4 + n3 * n16 + 1;
                        fArray3[n18] = fArray3[n18] + fArray7[1];
                    }
                }
            }
            return fComplexMatrix1D2;
        }
        if (n7 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n7 = Math.min(n7, this.rows);
            Future[] futureArray = new Future[n7];
            int n19 = this.rows / n7;
            for (int i = 0; i < n7; ++i) {
                final int n20 = i * n19;
                final int n21 = i == n7 - 1 ? this.rows : n20 + n19;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4 + n20 * n3;
                        float[] fArray6 = new float[2];
                        float[] fArray22 = new float[2];
                        if ((double)fArray2[0] == 0.0 && fArray2[1] == 0.0f) {
                            for (int i = n20; i < n21; ++i) {
                                float[] fArray32 = new float[2];
                                int n2 = SparseRCFComplexMatrix2D.this.rowPointers[i + 1];
                                for (int j = SparseRCFComplexMatrix2D.this.rowPointers[i]; j < n2; ++j) {
                                    fArray6[0] = fArray4[n6 + n5 * SparseRCFComplexMatrix2D.this.columnIndexes[j]];
                                    fArray6[1] = fArray4[n6 + n5 * SparseRCFComplexMatrix2D.this.columnIndexes[j] + 1];
                                    fArray22[0] = SparseRCFComplexMatrix2D.this.values[2 * j];
                                    fArray22[1] = SparseRCFComplexMatrix2D.this.values[2 * j + 1];
                                    fArray32 = FComplex.plus(fArray32, FComplex.mult(fArray22, fArray6));
                                }
                                fArray32 = FComplex.mult(fArray, fArray32);
                                fArray3[n] = fArray32[0];
                                fArray3[n + 1] = fArray32[1];
                                n += n3;
                            }
                        } else {
                            float[] fArray42 = new float[2];
                            for (int i = n20; i < n21; ++i) {
                                float[] fArray5 = new float[2];
                                int n32 = SparseRCFComplexMatrix2D.this.rowPointers[i + 1];
                                for (int j = SparseRCFComplexMatrix2D.this.rowPointers[i]; j < n32; ++j) {
                                    fArray6[0] = fArray4[n6 + n5 * SparseRCFComplexMatrix2D.this.columnIndexes[j]];
                                    fArray6[1] = fArray4[n6 + n5 * SparseRCFComplexMatrix2D.this.columnIndexes[j] + 1];
                                    fArray22[0] = SparseRCFComplexMatrix2D.this.values[2 * j];
                                    fArray22[1] = SparseRCFComplexMatrix2D.this.values[2 * j + 1];
                                    fArray5 = FComplex.plus(fArray5, FComplex.mult(fArray22, fArray6));
                                }
                                fArray5 = FComplex.mult(fArray, fArray5);
                                fArray42[0] = fArray3[n];
                                fArray42[1] = fArray3[n + 1];
                                fArray42 = FComplex.mult(fArray2, fArray42);
                                fArray3[n] = fArray5[0] + fArray42[0];
                                fArray3[n + 1] = fArray5[1] + fArray42[1];
                                n += n3;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n22 = n4;
            float[] fArray8 = new float[2];
            float[] fArray9 = new float[2];
            if ((double)fArray2[0] == 0.0 && fArray2[1] == 0.0f) {
                for (int i = 0; i < this.rows; ++i) {
                    float[] fArray10 = new float[2];
                    int n23 = this.rowPointers[i + 1];
                    for (int j = this.rowPointers[i]; j < n23; ++j) {
                        fArray8[0] = fArray4[n6 + n5 * this.columnIndexes[j]];
                        fArray8[1] = fArray4[n6 + n5 * this.columnIndexes[j] + 1];
                        fArray9[0] = this.values[2 * j];
                        fArray9[1] = this.values[2 * j + 1];
                        fArray10 = FComplex.plus(fArray10, FComplex.mult(fArray9, fArray8));
                    }
                    fArray10 = FComplex.mult(fArray, fArray10);
                    fArray3[n22] = fArray10[0];
                    fArray3[n22 + 1] = fArray10[1];
                    n22 += n3;
                }
            } else {
                float[] fArray11 = new float[2];
                for (int i = 0; i < this.rows; ++i) {
                    float[] fArray12 = new float[2];
                    int n24 = this.rowPointers[i + 1];
                    for (int j = this.rowPointers[i]; j < n24; ++j) {
                        fArray8[0] = fArray4[n6 + n5 * this.columnIndexes[j]];
                        fArray8[1] = fArray4[n6 + n5 * this.columnIndexes[j] + 1];
                        fArray9[0] = this.values[2 * j];
                        fArray9[1] = this.values[2 * j + 1];
                        fArray12 = FComplex.plus(fArray12, FComplex.mult(fArray9, fArray8));
                    }
                    fArray12 = FComplex.mult(fArray, fArray12);
                    fArray11[0] = fArray3[n22];
                    fArray11[1] = fArray3[n22 + 1];
                    fArray11 = FComplex.mult(fArray2, fArray11);
                    fArray3[n22] = fArray12[0] + fArray11[0];
                    fArray3[n22 + 1] = fArray12[1] + fArray11[1];
                    n22 += n3;
                }
            }
        }
        return fComplexMatrix1D2;
    }

    public FComplexMatrix2D zMult(FComplexMatrix2D fComplexMatrix2D, FComplexMatrix2D fComplexMatrix2D2, float[] fArray, float[] fArray2, boolean bl, boolean bl2) {
        boolean bl3;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = fComplexMatrix2D.rows();
        int n4 = fComplexMatrix2D.columns();
        if (bl2) {
            n3 = fComplexMatrix2D.columns();
            n4 = fComplexMatrix2D.rows();
        }
        int n5 = n4;
        boolean bl4 = bl3 = fComplexMatrix2D2 == null;
        if (fComplexMatrix2D2 == null) {
            fComplexMatrix2D2 = fComplexMatrix2D instanceof SparseRCFComplexMatrix2D ? new SparseRCFComplexMatrix2D(n, n5, n * n5) : new DenseFComplexMatrix2D(n, n5);
        }
        if (n3 != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? fComplexMatrix2D.viewDice() : fComplexMatrix2D).toStringShort());
        }
        if (fComplexMatrix2D2.rows() != n || fComplexMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (bl2 ? fComplexMatrix2D.viewDice() : fComplexMatrix2D).toStringShort() + ", " + fComplexMatrix2D2.toStringShort());
        }
        if (this == fComplexMatrix2D2 || fComplexMatrix2D == fComplexMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!(bl3 || (double)fArray2[0] == 1.0 && fArray2[1] == 0.0f)) {
            fComplexMatrix2D2.assign(FComplexFunctions.mult(fArray2));
        }
        if (fComplexMatrix2D instanceof DenseFComplexMatrix2D && fComplexMatrix2D2 instanceof DenseFComplexMatrix2D) {
            SparseRCFComplexMatrix2D sparseRCFComplexMatrix2D = bl ? this.getConjugateTranspose() : this;
            DenseFComplexMatrix2D denseFComplexMatrix2D = bl2 ? (DenseFComplexMatrix2D)fComplexMatrix2D.getConjugateTranspose() : (DenseFComplexMatrix2D)fComplexMatrix2D;
            DenseFComplexMatrix2D denseFComplexMatrix2D2 = (DenseFComplexMatrix2D)fComplexMatrix2D2;
            int[] nArray = sparseRCFComplexMatrix2D.rowPointers;
            int[] nArray2 = sparseRCFComplexMatrix2D.columnIndexes;
            float[] fArray3 = sparseRCFComplexMatrix2D.values;
            float[] fArray4 = new float[2];
            for (int i = 0; i < n; ++i) {
                int n6 = nArray[i + 1];
                for (int j = nArray[i]; j < n6; ++j) {
                    fArray4[0] = fArray3[2 * j];
                    fArray4[1] = fArray3[2 * j + 1];
                    float[] fArray5 = FComplex.mult(fArray, fArray4);
                    int n7 = nArray2[j];
                    denseFComplexMatrix2D2.viewRow(i).assign(denseFComplexMatrix2D.viewRow(n7), FComplexFunctions.plusMultSecond(fArray5));
                }
            }
        } else if (fComplexMatrix2D instanceof SparseRCFComplexMatrix2D && fComplexMatrix2D2 instanceof SparseRCFComplexMatrix2D) {
            int n8;
            SparseRCFComplexMatrix2D sparseRCFComplexMatrix2D = (SparseRCFComplexMatrix2D)fComplexMatrix2D2;
            SparseRCFComplexMatrix2D sparseRCFComplexMatrix2D2 = bl ? this.getConjugateTranspose() : this;
            SparseRCFComplexMatrix2D sparseRCFComplexMatrix2D3 = bl2 ? ((SparseRCFComplexMatrix2D)fComplexMatrix2D).getConjugateTranspose() : (SparseRCFComplexMatrix2D)fComplexMatrix2D;
            int[] nArray = sparseRCFComplexMatrix2D2.rowPointers;
            int[] nArray3 = sparseRCFComplexMatrix2D2.columnIndexes;
            float[] fArray6 = sparseRCFComplexMatrix2D2.values;
            int[] nArray4 = sparseRCFComplexMatrix2D3.rowPointers;
            int[] nArray5 = sparseRCFComplexMatrix2D3.columnIndexes;
            float[] fArray7 = sparseRCFComplexMatrix2D3.values;
            int[] nArray6 = sparseRCFComplexMatrix2D.rowPointers;
            int[] nArray7 = sparseRCFComplexMatrix2D.columnIndexes;
            float[] fArray8 = sparseRCFComplexMatrix2D.values;
            int n9 = nArray7.length;
            int[] nArray8 = new int[n4 + 1];
            for (n8 = 0; n8 < nArray8.length; ++n8) {
                nArray8[n8] = -1;
            }
            n8 = -1;
            float[] fArray9 = new float[2];
            float[] fArray10 = new float[2];
            float[] fArray11 = new float[2];
            for (int i = 0; i < n; ++i) {
                int n10;
                int n11 = nArray[i + 1];
                for (n10 = nArray[i]; n10 < n11; ++n10) {
                    fArray9[0] = fArray6[2 * n10];
                    fArray9[1] = fArray6[2 * n10 + 1];
                    float[] fArray12 = FComplex.mult(fArray, fArray9);
                    int n12 = nArray3[n10];
                    int n13 = nArray4[n12 + 1];
                    for (int j = nArray4[n12]; j < n13; ++j) {
                        int n14 = nArray5[j];
                        int n15 = nArray8[n14];
                        if (n15 == -1) {
                            if (++n8 >= n9) {
                                throw new IllegalArgumentException("The max number of nonzero elements in C is too small.");
                            }
                            nArray7[n8] = n14;
                            nArray8[n14] = n8;
                            fArray10[0] = fArray7[2 * j];
                            fArray10[1] = fArray7[2 * j + 1];
                            fArray10 = FComplex.mult(fArray12, fArray10);
                            fArray8[2 * n8] = fArray10[0];
                            fArray8[2 * n8 + 1] = fArray10[1];
                            continue;
                        }
                        fArray10[0] = fArray7[2 * j];
                        fArray10[1] = fArray7[2 * j + 1];
                        fArray10 = FComplex.mult(fArray12, fArray10);
                        int n16 = 2 * n15;
                        fArray8[n16] = fArray8[n16] + fArray10[0];
                        int n17 = 2 * n15 + 1;
                        fArray8[n17] = fArray8[n17] + fArray10[1];
                    }
                }
                for (n10 = nArray6[i]; n10 < n8 + 1; ++n10) {
                    nArray8[nArray7[n10]] = -1;
                }
                nArray6[i + 1] = n8 + 1;
            }
        } else {
            if (bl2) {
                fComplexMatrix2D = fComplexMatrix2D.getConjugateTranspose();
            }
            FComplexMatrix1D[] fComplexMatrix1DArray = new FComplexMatrix1D[n2];
            int n18 = n2;
            while (--n18 >= 0) {
                fComplexMatrix1DArray[n18] = fComplexMatrix2D.viewRow(n18);
            }
            FComplexMatrix1D[] fComplexMatrix1DArray2 = new FComplexMatrix1D[n];
            int n19 = n;
            while (--n19 >= 0) {
                fComplexMatrix1DArray2[n19] = fComplexMatrix2D2.viewRow(n19);
            }
            FComplexPlusMultSecond fComplexPlusMultSecond = FComplexPlusMultSecond.plusMult(new float[2]);
            int[] nArray = this.columnIndexes;
            float[] fArray13 = this.values;
            float[] fArray14 = new float[2];
            int n20 = this.rows;
            while (--n20 >= 0) {
                int n21 = this.rowPointers[n20];
                int n22 = this.rowPointers[n20 + 1];
                while (--n22 >= n21) {
                    int n23 = nArray[n22];
                    fArray14[0] = fArray13[2 * n22];
                    fArray14[1] = fArray13[2 * n22 + 1];
                    fComplexPlusMultSecond.multiplicator = FComplex.mult(fArray14, fArray);
                    if (!bl) {
                        fComplexMatrix1DArray2[n20].assign(fComplexMatrix1DArray[n23], fComplexPlusMultSecond);
                        continue;
                    }
                    fComplexMatrix1DArray2[n23].assign(fComplexMatrix1DArray[n20], fComplexPlusMultSecond);
                }
            }
        }
        return fComplexMatrix2D2;
    }

    private float cumsum(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
            n2 += nArray2[i];
            f += (float)nArray2[i];
            nArray2[i] = nArray[i];
        }
        nArray[n] = n2;
        return f;
    }

    private void realloc(int n) {
        if (n <= 0) {
            n = this.rowPointers[this.rows];
        }
        int[] nArray = new int[n];
        int n2 = Math.min(n, this.columnIndexes.length);
        System.arraycopy(this.columnIndexes, 0, nArray, 0, n2);
        this.columnIndexes = nArray;
        float[] fArray = new float[2 * n];
        n2 = Math.min(n, this.values.length);
        System.arraycopy(this.values, 0, fArray, 0, n2);
        this.values = fArray;
    }

    protected FComplexMatrix2D getContent() {
        return this;
    }

    protected void insert(int n, int n2, int n3, float[] fArray) {
        IntArrayList intArrayList = new IntArrayList(this.columnIndexes);
        intArrayList.setSizeRaw(this.rowPointers[this.rows]);
        FloatArrayList floatArrayList = new FloatArrayList(this.values);
        floatArrayList.setSizeRaw(2 * this.rowPointers[this.rows]);
        intArrayList.beforeInsert(n3, n2);
        floatArrayList.beforeInsert(2 * n3, fArray[0]);
        floatArrayList.beforeInsert(2 * n3 + 1, fArray[1]);
        int n4 = this.rowPointers.length;
        while (--n4 > n) {
            int n5 = n4;
            this.rowPointers[n5] = this.rowPointers[n5] + 1;
        }
        this.columnIndexes = intArrayList.elements();
        this.values = floatArrayList.elements();
    }

    protected void insert(int n, int n2, int n3, float f, float f2) {
        IntArrayList intArrayList = new IntArrayList(this.columnIndexes);
        intArrayList.setSizeRaw(this.rowPointers[this.rows]);
        FloatArrayList floatArrayList = new FloatArrayList(this.values);
        floatArrayList.setSizeRaw(2 * this.rowPointers[this.rows]);
        intArrayList.beforeInsert(n3, n2);
        floatArrayList.beforeInsert(2 * n3, f);
        floatArrayList.beforeInsert(2 * n3 + 1, f2);
        int n4 = this.rowPointers.length;
        while (--n4 > n) {
            int n5 = n4;
            this.rowPointers[n5] = this.rowPointers[n5] + 1;
        }
        this.columnIndexes = intArrayList.elements();
        this.values = floatArrayList.elements();
    }

    protected void remove(int n, int n2) {
        IntArrayList intArrayList = new IntArrayList(this.columnIndexes);
        intArrayList.setSizeRaw(this.rowPointers[this.rows]);
        FloatArrayList floatArrayList = new FloatArrayList(this.values);
        floatArrayList.setSizeRaw(this.rowPointers[this.rows]);
        intArrayList.remove(n2);
        floatArrayList.remove(2 * n2);
        floatArrayList.remove(2 * n2 + 1);
        int n3 = this.rowPointers.length;
        while (--n3 > n) {
            int n4 = n3;
            this.rowPointers[n4] = this.rowPointers[n4] - 1;
        }
        this.columnIndexes = intArrayList.elements();
        this.values = floatArrayList.elements();
    }
}

