% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phy_debias.r
\name{physician_debias}
\alias{physician_debias}
\title{Implement physician debias algorithm}
\usage{
physician_debias(data, phy.id, phy.code, phylist, causelist, tol = 1e-04,
  max.itr = 5000, verbose = FALSE)
}
\arguments{
\item{data}{The original data to be used. It is suggested to use similar
input as InterVA4, with the first column being death IDs. The only
difference in input is InsilicoVA takes three levels: ``present'',
``absent'', and ``missing (no data)''. Similar to InterVA software,
``present'' symptoms takes value ``Y''; ``absent'' symptoms take take value
``NA'' or ``''. For missing symptoms, e.g., questions not asked or answered
in the original interview, corrupted data, etc., the input should be coded
by ``.'' to distinguish from ``absent'' category. The order of the columns does
not matter as long as the column names are correct. Currently it cannot other
non-symptom columns such as subpopulation. And the first column should be 
the death ID. Everything other than the death ID, physician ID, and physician 
codes should be symptoms.}

\item{phy.id}{vector of column names for physician ID}

\item{phy.code}{vector of column names for physician code}

\item{phylist}{vector of physician ID used in physician ID columns}

\item{causelist}{vector of causes used in physician code columns}

\item{tol}{tolerance of the EM algorithm}

\item{max.itr}{maximum iteration to run}

\item{verbose}{logical indicator for printing out likelihood change}
}
\value{
\item{code.debias}{Individual cause likelihood distribution}

\item{csmf}{Cause specific distribution in the sample}

\item{phy.bias}{Bias matrix for each physician}

\item{cond.prob}{Conditional probability of symptoms given causes}
}
\description{
This function implements physician debias algorithm proposed in Salter-Townshend 
and Murphy (2013).
}
\examples{

data(RandomPhysician)
head(RandomPhysician[, 1:10])
\dontrun{
causelist <- c("Communicable", "TB/AIDS", "Maternal", 
               "NCD", "External", "Unknown")
phydebias <- physician_debias(RandomPhysician, phy.id = c("rev1", "rev2"), 
phy.code = c("code1", "code2"), phylist = c("doc1", "doc2"), 
causelist = causelist, tol = 0.0001, max.itr = 5000)

# see the first physician's bias matrix
round(phydebias$phy.bias[[1]], 2)
}
}
\references{
M. Salter-Townshend and T. B. Murphy (2013).\emph{Sentiment 
analysis of online media}. \cr \emph{In Algorithms from and for Nature and 
Life, pages 137-145, Springer.}
}
