/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tfloat.sampling;

import cern.colt.PersistentObject;
import cern.colt.Timer;
import cern.jet.random.tfloat.AbstractFloatDistribution;
import cern.jet.random.tfloat.engine.FloatRandomEngine;

public class FloatRandomSampler
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    long my_n;
    long my_N;
    long my_low;
    FloatRandomEngine my_RandomGenerator;

    public FloatRandomSampler(long l, long l2, long l3, FloatRandomEngine floatRandomEngine) {
        if (l < 0L) {
            throw new IllegalArgumentException("n must be >= 0");
        }
        if (l > l2) {
            throw new IllegalArgumentException("n must by <= N");
        }
        this.my_n = l;
        this.my_N = l2;
        this.my_low = l3;
        if (floatRandomEngine == null) {
            floatRandomEngine = AbstractFloatDistribution.makeDefaultGenerator();
        }
        this.my_RandomGenerator = floatRandomEngine;
    }

    public Object clone() {
        FloatRandomSampler floatRandomSampler = (FloatRandomSampler)super.clone();
        floatRandomSampler.my_RandomGenerator = (FloatRandomEngine)this.my_RandomGenerator.clone();
        return floatRandomSampler;
    }

    public static void main(String[] stringArray) {
        long l = Long.parseLong(stringArray[0]);
        long l2 = Long.parseLong(stringArray[1]);
        long l3 = Long.parseLong(stringArray[2]);
        int n = Integer.parseInt(stringArray[3]);
        int n2 = Integer.parseInt(stringArray[4]);
        FloatRandomSampler.test(l, l2, l3, n, n2);
    }

    public void nextBlock(int n, long[] lArray, int n2) {
        if ((long)n > this.my_n) {
            throw new IllegalArgumentException("Random sample exhausted.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative count.");
        }
        if (n == 0) {
            return;
        }
        FloatRandomSampler.sample(this.my_n, this.my_N, n, this.my_low, lArray, n2, this.my_RandomGenerator);
        long l = lArray[n2 + n - 1];
        this.my_n -= (long)n;
        this.my_N = this.my_N - l - 1L + this.my_low;
        this.my_low = l + 1L;
    }

    protected static void rejectMethodD(long l, long l2, int n, long l3, long[] lArray, int n2, FloatRandomEngine floatRandomEngine) {
        int n3;
        long l4;
        l = l2 - l;
        long l5 = -1L + l3;
        long l6 = -13L;
        float f = l;
        float f2 = (float)(1.0 / (double)f);
        float f3 = l2;
        float f4 = (float)Math.exp(Math.log(floatRandomEngine.raw()) * (double)f2);
        long l7 = -l + 1L + l2;
        float f5 = -f + 1.0f + f3;
        while (l > 1L && n > 0) {
            float f6;
            float f7 = (float)(1.0 / (-1.0 + (double)f));
            while (true) {
                long l8;
                float f8;
                float f9;
                if ((l4 = (long)(f9 = f3 * (-f4 + 1.0f))) >= l7) {
                    f4 = (float)Math.exp(Math.log(floatRandomEngine.raw()) * (double)f2);
                    continue;
                }
                float f10 = floatRandomEngine.raw();
                f6 = -l4;
                float f11 = (float)Math.exp(Math.log(f10 * f3 / f5) * (double)f7);
                f4 = f11 * (-f9 / f3 + 1.0f) * (f5 / (f6 + f5));
                if ((double)f4 <= 1.0) break;
                float f12 = 1.0f;
                float f13 = -1.0f + f3;
                if (l - 1L > l4) {
                    f8 = -f + f3;
                    l8 = -l4 + l2;
                } else {
                    f8 = -1.0f + f6 + f3;
                    l8 = l7;
                }
                for (long i = l2 - 1L; i >= l8; --i) {
                    f12 = f12 * f13 / f8;
                    f13 -= 1.0f;
                    f8 -= 1.0f;
                }
                if ((double)(f3 / (-f9 + f3)) >= (double)f11 * Math.exp(Math.log(f12) * (double)f7)) {
                    f4 = (float)Math.exp(Math.log(floatRandomEngine.raw()) * (double)f7);
                    break;
                }
                f4 = (float)Math.exp(Math.log(floatRandomEngine.raw()) * (double)f2);
            }
            n3 = n;
            if (l4 < (long)n3) {
                n3 = (int)l4;
            }
            n -= n3;
            while (--n3 >= 0) {
                lArray[n2++] = ++l5;
            }
            ++l5;
            l2 -= l4 + 1L;
            f3 = f6 + (-1.0f + f3);
            --l;
            f -= 1.0f;
            f2 = f7;
            l7 = -l4 + l7;
            f5 = f6 + f5;
        }
        if (n > 0) {
            l4 = (long)((float)l2 * f4);
            n3 = n;
            if (l4 < (long)n3) {
                n3 = (int)l4;
            }
            n -= n3;
            while (--n3 >= 0) {
                lArray[n2++] = ++l5;
            }
            ++l5;
            while (--n >= 0) {
                lArray[n2++] = ++l5;
            }
        }
    }

    public static void sample(long l, long l2, int n, long l3, long[] lArray, int n2, FloatRandomEngine floatRandomEngine) {
        if (l <= 0L || n <= 0) {
            return;
        }
        if ((long)n > l) {
            throw new IllegalArgumentException("count must not be greater than n");
        }
        if (floatRandomEngine == null) {
            floatRandomEngine = AbstractFloatDistribution.makeDefaultGenerator();
        }
        if ((long)n == l2) {
            long l4 = l3;
            int n3 = n2 + n;
            int n4 = n2;
            while (n4 < n3) {
                lArray[n4++] = l4++;
            }
            return;
        }
        if ((double)l < (double)l2 * 0.95) {
            FloatRandomSampler.sampleMethodD(l, l2, n, l3, lArray, n2, floatRandomEngine);
        } else {
            FloatRandomSampler.rejectMethodD(l, l2, n, l3, lArray, n2, floatRandomEngine);
        }
    }

    protected static void sampleMethodA(long l, long l2, int n, long l3, long[] lArray, int n2, FloatRandomEngine floatRandomEngine) {
        long l4;
        long l5 = -1L + l3;
        float f = l2 - l;
        float f2 = l2;
        while (l >= 2L && n > 0) {
            float f3 = floatRandomEngine.raw();
            l4 = 0L;
            float f4 = f / f2;
            while (f4 > f3) {
                ++l4;
                f4 = f4 * (f -= 1.0f) / (f2 -= 1.0f);
            }
            lArray[n2++] = l5 += l4 + 1L;
            --n;
            f2 -= 1.0f;
            --l;
        }
        if (n > 0) {
            l4 = (long)((float)Math.round(f2) * floatRandomEngine.raw());
            lArray[n2] = l5 += l4 + 1L;
        }
    }

    protected static void sampleMethodD(long l, long l2, int n, long l3, long[] lArray, int n2, FloatRandomEngine floatRandomEngine) {
        long l4;
        long l5 = -1L + l3;
        long l6 = -13L;
        float f = l;
        float f2 = (float)(1.0 / (double)f);
        float f3 = l2;
        float f4 = (float)Math.exp(Math.log(floatRandomEngine.raw()) * (double)f2);
        long l7 = -l + 1L + l2;
        float f5 = -f + 1.0f + f3;
        for (long i = -l6 * l; l > 1L && n > 0 && i < l2; i += l6) {
            float f6;
            float f7 = (float)(1.0 / (-1.0 + (double)f));
            while (true) {
                long l8;
                float f8;
                float f9;
                if ((l4 = (long)(f9 = f3 * (-f4 + 1.0f))) >= l7) {
                    f4 = (float)Math.exp(Math.log(floatRandomEngine.raw()) * (double)f2);
                    continue;
                }
                float f10 = floatRandomEngine.raw();
                f6 = -l4;
                float f11 = (float)Math.exp(Math.log(f10 * f3 / f5) * (double)f7);
                f4 = f11 * (-f9 / f3 + 1.0f) * (f5 / (f6 + f5));
                if ((double)f4 <= 1.0) break;
                float f12 = 1.0f;
                float f13 = -1.0f + f3;
                if (l - 1L > l4) {
                    f8 = -f + f3;
                    l8 = -l4 + l2;
                } else {
                    f8 = -1.0f + f6 + f3;
                    l8 = l7;
                }
                for (long j = l2 - 1L; j >= l8; --j) {
                    f12 = f12 * f13 / f8;
                    f13 -= 1.0f;
                    f8 -= 1.0f;
                }
                if ((double)(f3 / (-f9 + f3)) >= (double)f11 * Math.exp(Math.log(f12) * (double)f7)) {
                    f4 = (float)Math.exp(Math.log(floatRandomEngine.raw()) * (double)f7);
                    break;
                }
                f4 = (float)Math.exp(Math.log(floatRandomEngine.raw()) * (double)f2);
            }
            lArray[n2++] = l5 += l4 + 1L;
            --n;
            l2 -= l4 + 1L;
            f3 = f6 + (-1.0f + f3);
            --l;
            f -= 1.0f;
            f2 = f7;
            l7 = -l4 + l7;
            f5 = f6 + f5;
        }
        if (n > 0) {
            if (l > 1L) {
                FloatRandomSampler.sampleMethodA(l, l2, n, l5 + 1L, lArray, n2, floatRandomEngine);
            } else {
                l4 = (long)((float)l2 * f4);
                lArray[n2++] = l5 += l4 + 1L;
            }
        }
    }

    public static void test(long l, long l2, long l3, int n, int n2) {
        long[] lArray = new long[n];
        long l4 = l / (long)n;
        Timer timer = new Timer().start();
        long l5 = n2;
        while (--l5 >= 0L) {
            FloatRandomSampler floatRandomSampler = new FloatRandomSampler(l, l2, l3, AbstractFloatDistribution.makeDefaultGenerator());
            for (long i = 0L; i < l4; ++i) {
                floatRandomSampler.nextBlock(n, lArray, 0);
            }
            int n3 = (int)(l - (long)n * l4);
            if (n3 <= 0) continue;
            floatRandomSampler.nextBlock(n3, lArray, 0);
        }
        timer.stop();
        System.out.println("single run took " + timer.elapsedTime() / (double)n2);
        System.out.println("Good bye.\n");
    }

    protected static void testNegAlphaInv(String[] stringArray) {
    }
}

