% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_manual_simple.R
\name{input_manual_simple}
\alias{input_manual_simple}
\title{Input Manual Simple}
\usage{
input_manual_simple(
  test_name,
  facet_names,
  items_per_facet,
  item_names,
  test_loadings,
  facet_loadings,
  correlation_matrix
)
}
\arguments{
\item{test_name}{character; the name of the test.}

\item{facet_names}{character; the names of the facets in correct order.}

\item{items_per_facet}{integer; number of items per facet in correct order
(determined by facet_names), if all facets have the same number of items a
single number can be used, e.g. 5 instead of c(5, 5, 5, 5).}

\item{item_names}{character or integer; the names of the items in correct
order (determined by facet_names).}

\item{test_loadings}{integer; vector of the factor loadings from the single
factor model of the test or a group factor model of multiple tests in
correct order (determined by item_names).}

\item{facet_loadings}{integer; vector of the factor loadings on the facet
factors from the group factor model in correct order (determined by
item_names).}

\item{correlation_matrix}{matrix containing the latent correlations between
facets, pay attention to the order of rows and columns, which is determined
by facet_names.}
}
\value{
list containing "raw" data, that needs to be pre-processed using
 \code{\link{input_manual_process}}.
}
\description{
Generates manual data input for a simple model with one test.
}
\details{
Pay attention to the order of facets and items, it has to be coherent
 throughout the whole data. facet_names and items_per_facet determine which
 facet is listed first and how many items there are listed for that facet.
 item_names, test_loadings and facet_loadings have to match that order.
 The correlation matrix uses the order in facet_names for rows and columns.

 Visually inspect the returned object before continuing with
 \code{\link{input_manual_process}}!
}
\examples{
# these RSES data can also be seen in self_confidence, the example data of
# this package
mydata <- input_manual_simple(
test_name = "RSES",
facet_names = c("Ns", "Ps"),
items_per_facet = 5,
item_names = c(2, 5, 6, 8, 9,
              1, 3, 4, 7, 10),
test_loadings = c(.5806, .5907, .6179, .5899, .6559,
                    .6005, .4932, .4476, .5033, .6431),
facet_loadings = c(.6484, .6011, .6988, .6426, .6914,
                       .6422, .5835, .536, .5836, .6791),
correlation_matrix = matrix(data = c(1, .69,
                                    .69, 1),
                           nrow = 2,
                           ncol = 2))
mydata
input_manual_process(mydata)

}
\seealso{
\code{\link{input_manual_nested}} \code{\link{input_manual_process}}
}
