% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RotationDetect.R
\name{RotationDetect}
\alias{RotationDetect}
\title{Detect Rotating Patterns in Vector Fields}
\usage{
RotationDetect(vfdf)
}
\arguments{
\item{vfdf}{A data frame as returned by \code{\link{DispField}},
\code{\link{DispFieldST}}, or \code{\link{DispFieldSTall}} with at least
five rows (more is better)}
}
\value{
A data frame as returned by \code{\link{DispField}},
\code{\link{DispFieldST}}, or \code{\link{DispFieldSTall}}, with three
additional columns. The first additional column is called Pattern in which
the patterns around each focal cell are categorized as clockwise,
counter-clockwise, partial clockwise, partial counter-clockwise, or NA. The
second additional column, called SubPattern, indicates whether all arrows
point towards (convergence) or away (divergence) from the focal cell. The
third additional column is called PatternCt, which contains a one if all
four neighbourhood grid cells contain displacement estimates, and a NA
otherwise.
}
\description{
Detect patterns in vector fields represented on a grid by looking in the
rook's neighbourhood of each grid cell. This function is analogous to
\code{\link{PatternDetect}}, except that it detects rotational patterns. Four
patterns are detected: clockwise rotation when rotation in all four
neighbbour grids appears clockwise, counter clockwise rotation when rotation
in all four neighbour grids appears counter-clockwise, and partial clockwise
and counter-clockwise rotation, when all but one of the four adjacent
neighbour cells has vectors that indicate rotation. For all of the patterns
above a sub-pattern is specified as convergence when all of the vectors in
the four adjacent grids point towards the focal cell or a divergence when all
of the vectors in the four adjacent grids point away from the focal cell.
}
\examples{
# creating rotation patterns
Mat1 <- matrix(rep(0,9*9), nrow = 9)
Mat1[c(1:3), 4] <- 1
Mat1[c(7:9), 6] <- 1
Mat1[4, c(7:9)] <- 1
Mat1[6, c(1:3)] <- 1
Mat1

Mat2 <- matrix(rep(0,9*9), nrow = 9)
Mat2[c(1:3), 5] <- 1
Mat2[c(7:9), 5] <- 1
Mat2[5, c(7:9)] <- 1
Mat2[5, c(1:3)] <- 1
Mat2

# rasterizing
rast1 <- terra::rast(Mat1)
terra::plot(rast1)
rast2 <- terra::rast(Mat2)
terra::plot(rast2)

# Detecting clockwise rotation
(VFdf1 <- DispField(rast1, rast2, factv1 = 3, facth1 = 3, restricted = TRUE))
(patdf1 <- RotationDetect(VFdf1))

# Detecting counter-clockwise rotation
(VFdf2 <- DispField(rast2, rast1, factv1 = 3, facth1 = 3, restricted = TRUE))
(patdf2 <- RotationDetect(VFdf2))
}
