% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcNpmleCalibP.R
\name{CalcNpmleCalibP}
\alias{CalcNpmleCalibP}
\title{Calculating the probabilities of positive binary exposure status at a given time point using a nonparametric calibration model}
\usage{
CalcNpmleCalibP(w, w.res, point, fit.npmle)
}
\arguments{
\item{w}{A matrix of time points when measurements on the binary covariate were obtained.}

\item{w.res}{A matrix of measurement results of the binary covariate. Each measurement corresponds to the time points in \code{w}}

\item{point}{The time point at which the probabilities are estimated.}

\item{fit.npmle}{The result of \code{icenReg::ic_np} on the interval-censored data}
}
\value{
A vector of estimated probabilities of positive exposure status at time \code{point}.
}
\description{
For a given time point, calculate the probability of positive exposure value  for multiple observations (participants). 
The function uses the results of a nonparametric calibration model fit, and given collected data on the history 
of the binary exposure for each participant.
}
\examples{
sim.data <- ICcalib:::SimCoxIntervalCensSingle(n.sample = 200, lambda = 0.1, 
                                               alpha = 0.25, beta0 = log(0.5), 
                                               mu = 0.2, n.points = 2, 
                                               weib.shape = 1, weib.scale = 2)
# Fit nonparametric calibration model
fit.npmle <- FitCalibNpmle(w = sim.data$w, w.res = sim.data$w.res)
# Calculate the conditional probabilities of binary covariate=1 at time one
probs <- CalcNpmleCalibP(w = sim.data$w, w.res = sim.data$w.res, 
                         point = 1, fit.npmle = fit.npmle)
summary(probs)
}
