% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{rimle_clust}
\alias{rimle_clust}
\title{Robust Improper Maximum Likelihood Clustering}
\usage{
rimle_clust(X, k, clusters_only = FALSE, ...)
}
\arguments{
\item{X}{a numeric matrix or data frame of the data. It corresponds to the
argument \code{data}.}

\item{k}{the number of clusters searched for. It corresponds to the argument
\code{G}.}

\item{clusters_only}{boolean. If \code{TRUE} only the partition of the data
is returned as a vector. If \code{FALSE} the usual output of the
\code{\link[otrimle:rimle]{otrimle::rimle()}} function is returned.}

\item{...}{other arguments to pass to \code{\link[otrimle:rimle]{otrimle::rimle()}}.}
}
\value{
If \code{clusters_only} is \code{TRUE} a vector of the new partition
of the data is returned, i.e a vector of integers (from \code{1:k})
indicating the cluster to which each observation is allocated.
0 indicates trimmed observations.

Otherwise a list is returned with the following components:
\item{clust_method}{the name of the clustering method, i.e, "rimle".}
\item{clusters}{the vector of the new partition of the data, i.e. a vector of
integers (from \code{1:k}) indicating the cluster to which each observation
is allocated.
0 indicates outlying observations.}
\item{...}{an object of class \code{"rimle"}}
}
\description{
Wrapper for performing Robust Improper Maximum Likelihood Clustering
clustering from \code{\link[otrimle:rimle]{otrimle::rimle()}}.
}
\examples{
rimle_clust(iris[,1:4], k = 3, clusters_only = TRUE)
}
\seealso{
\code{\link[otrimle:rimle]{otrimle::rimle()}}
}
\author{
Aurore Archimbaud
}
