% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{get_panels_from_fit}
\alias{get_panels_from_fit}
\title{Extract Panel Details from Group Lasso Fit}
\usage{
get_panels_from_fit(gene_lengths, fit, gene_list, mut_types_list)
}
\arguments{
\item{gene_lengths}{(dataframe)
A table with two columns: Hugo_Symbol and max_cds, providing the lengths of the genes to be modelled.}

\item{fit}{(list)
A fit from the group lasso algorithm, produced by the function gglasso (package: gglasso).}

\item{gene_list}{(character)
A character vector of genes listing the genes (in order) included in the model pred_fit.}

\item{mut_types_list}{(character)
A character vector listing the mutation type groupings (in order) included in the model pred_fit.}
}
\value{
A list of two elements:
\itemize{
\item panel_genes: A matrix where each row corresponds to a gene, each column to an iteration of the group
lasso with a different penalty factor, and the elements booleans specifying whether that gene was selected
to be included in that iteration.
\item panel_lengths:
}
}
\description{
An internal function for analysing a group Lasso fit as part of the predictive model learning procedure, which returns the sets of genes identified by different iterations of the group Lasso algorithm.
}
\examples{
panels <- get_panels_from_fit(example_maf_data$gene_lengths, example_first_pred_tmb$fit,
example_gen_model$names$gene_list, mut_types_list = example_gen_model$names$mut_types_list)

print(panels$fit)
}
