% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ID_functions.R
\name{AnnotateIDVCF}
\alias{AnnotateIDVCF}
\title{Add sequence context to an in-memory ID (insertion/deletion) VCF, and
confirm that they match the given reference genome}
\usage{
AnnotateIDVCF(
  ID.vcf,
  ref.genome,
  flag.mismatches = 0,
  name.of.VCF = NULL,
  suppress.discarded.variants.warnings = TRUE
)
}
\arguments{
\item{ID.vcf}{An in-memory ID (insertion/deletion) VCF as a
\code{data.frame}. This function expects that there is a "context base" to
the left, for example REF = ACG, ALT = A (deletion of CG) or REF = A, ALT =
ACC (insertion of CC).}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{flag.mismatches}{Deprecated. If there are ID variants whose \code{REF}
do not match the extracted sequence from \code{ref.genome}, the function
will automatically discard these variants. See element
\code{discarded.variants} in the return value for more details.}

\item{name.of.VCF}{Name of the VCF file.}

\item{suppress.discarded.variants.warnings}{Logical. Whether to suppress
warning messages showing information about the discarded variants. Default
is TRUE.}
}
\value{
A list of elements:
\itemize{
\item \code{annotated.vcf}: The original VCF data
frame with two new columns added to the input data frame:
\itemize{
\item \code{seq.context}: The sequence embedding the variant.
\item \code{seq.context.width}: The width of \code{seq.context} to the left.
}
\item \code{discarded.variants}: \strong{Non-NULL only if} there are variants
that were excluded from the analysis. See the added extra column
\code{discarded.reason} for more details.
}
}
\description{
Add sequence context to an in-memory ID (insertion/deletion) VCF, and
confirm that they match the given reference genome
}
\examples{
file <- c(system.file("extdata/Strelka-ID-vcf/",
                      "Strelka.ID.GRCh37.s1.vcf",
                      package = "ICAMS"))
ID.vcf <- ReadStrelkaIDVCFs(file)[[1]]
if (requireNamespace("BSgenome.Hsapiens.1000genomes.hs37d5", quietly = TRUE)) {
  list <- AnnotateIDVCF(ID.vcf, ref.genome = "hg19")
  annotated.ID.vcf <- list$annotated.vcf}
}
