% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{ReadVCF}
\alias{ReadVCF}
\title{Read in the data lines of a Variant Call Format (VCF) file}
\usage{
ReadVCF(file, variant.caller = NULL, name.of.VCF = NULL, tumor.col.name = NA)
}
\arguments{
\item{file}{The name/path of the VCF file, or a complete URL.}

\item{variant.caller}{Name of the variant caller that produces the VCF, can
be either \code{strelka}, \code{mutect} or \code{freebayes}. This
information is needed to calculate the VAFs (variant allele frequencies).
If \code{NULL}(default), then VAF and read depth information will not be
added to the original VCF.}

\item{name.of.VCF}{Name of the VCF file. If \code{NULL}(default), this
function will remove all of the path up to and including the last path
separator (if any) in \code{file} and file path without extensions (and the
leading dot) will be used as the name of the VCF file.}

\item{tumor.col.name}{Optional. Only applicable to \strong{Mutect} VCF. Name
of the column in \strong{Mutect} VCF which contains the tumor sample
information. It \strong{must} have quotation marks. If
\code{tumor.col.name} is equal to \code{NA}(default), this function will
use the 10th column to calculate VAFs. See \code{\link{GetMutectVAF}} for
more details.}
}
\value{
A data frame storing data lines of the VCF file with two additional
  columns added which contain the VAF(variant allele frequency) and read
  depth information.
}
\description{
Read in the data lines of a Variant Call Format (VCF) file
}
\keyword{internal}
