% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strandbias_functions.R
\name{PlotTransBiasGeneExpToPdf}
\alias{PlotTransBiasGeneExpToPdf}
\title{Plot transcription strand bias with respect to gene expression values to a
PDF file.}
\usage{
PlotTransBiasGeneExpToPdf(annotated.SBS.vcf, file, expression.data,
  Ensembl.gene.ID.col, expression.value.col, num.of.bins,
  plot.type = c("C>A", "C>G", "C>T", "T>A", "T>C", "T>G"),
  damaged.base = NULL)
}
\arguments{
\item{annotated.SBS.vcf}{An SBS VCF annotated by
\code{\link{AnnotateSBSVCF}}. It \strong{must} have transcript range
information added.}

\item{file}{The name of output file.}

\item{expression.data}{A \code{\link{data.table}} which contains the
expression values of genes. \cr See \code{\link{GeneExpressionData}} for more
details.}

\item{Ensembl.gene.ID.col}{Name of column which has the Ensembl gene ID
information in \code{expression.data}.}

\item{expression.value.col}{Name of column which has the gene expression
values in \code{expression.data}.}

\item{num.of.bins}{The number of bins that will be plotted on the graph.}

\item{plot.type}{A vector of character indicating types to be plotted. It
can be one or more types from "C>A", "C>G", "C>T", "T>A", "T>C", "T>G".
The default is to print all the six mutation types.}

\item{damaged.base}{One of \code{NULL}, \code{"purine"} or
\code{"pyrimidine"}. This function allocates approximately
equal numbers of mutations from \code{damaged.base} into
each of \code{num.of.bins} bin by expression level. E.g.
if \code{damaged.base} is \code{"purine"}, then mutations from
A and G will be allocated in approximately equal numbers to
each expression-level bin. The rationale for the name \code{damaged.base}
is that the direction of strand bias is a result of whether the damage
occurs on a purine or pyrimidine.
If \code{NULL}, the function attempts to infer the \code{damaged.base}
based on mutation counts.}
}
\value{
A list whose first element is a logic value indicating whether the
  plot is successful. The second element is a named numeric vector containing
  the p-values printed on the plot.
}
\description{
Plot transcription strand bias with respect to gene expression values to a
PDF file.
}
\section{Note}{
 
The p-values are calculated by logistic regression using function
\code{\link[stats]{glm}}. The dependent variable is labeled "1" and "0" if
the mutation from \code{annotated.SBS.vcf} falls onto the untranscribed and
transcribed strand respectively. The independent variable is the binary
logarithm of the gene expression value from \code{expression.data} plus one,
i.e. \eqn{log_2 (x + 1)}{log2 (x + 1)} where \eqn{x} stands for gene
expression value.
}

\examples{
file <- c(system.file("extdata",
                      "Strelka.SBS.GRCh37.vcf",
                      package = "ICAMS"))
list.of.vcfs <- ReadAndSplitStrelkaSBSVCFs(file)
SBS.vcf <- list.of.vcfs$SBS.vcfs[[1]]             
if (requireNamespace("BSgenome.Hsapiens.1000genomes.hs37d5", quietly = TRUE)) {
  annotated.SBS.vcf <- AnnotateSBSVCF(SBS.vcf, ref.genome = "hg19",
                                      trans.ranges = trans.ranges.GRCh37)
  PlotTransBiasGeneExpToPdf(annotated.SBS.vcf = annotated.SBS.vcf, 
                            expression.data = gene.expression.data.HepG2, 
                            Ensembl.gene.ID.col = "Ensembl.gene.ID", 
                            expression.value.col = "TPM", 
                            num.of.bins = 4, 
                            plot.type = c("C>A","C>G","C>T","T>A","T>C"), 
                            file = file.path(tempdir(), "test.pdf"))
}
}
