% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foopTTable.R
\name{spTcteTab}
\alias{spTcteTab}
\title{Table of Entropies, Function of Pressure for Fixed Temperature}
\usage{
spTcteTab(p1, p2, dp, T)
}
\arguments{
\item{p1}{initial Pressure [ MPa ]}

\item{p2}{final Pressure [ MPa ]}

\item{dp}{Pressure increment [ MPa ]}

\item{T}{Temperature [ K ]}
}
\value{
A table of Entropies for fixed T and a p Interval: p1:p2.
}
\description{
The function \code{spTcteTab(p1, p2, dp, T)} returns a table of 
    Entropies [kJ kg-1 K-1] for a fixed T [K] within a range of p [MPa]: p1:p2 [MPa]
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{http://www.iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
p1 <- 1.0
p2 <- 10.
dp <- 1.
T <- 500.
spTcteTab(p1, p2, dp, T)

p1 <- 10.
p2 <- 100.
dp <- 10.
T <- 450.
Tabs <- spTcteTab(p1, p2, dp, T)

}

